;;; x-symbol-xmas20.el --- make package x-symbol work with XEmacs-20.X

;; Copyright (C) 1998-1999 Free Software Foundation, Inc.
;;
;; Author: Christoph Wedler <wedler@fmi.uni-passau.de>
;; Maintainer: (Please use `M-x x-symbol-package-bug' to contact the maintainer)
;; Version: $Id: x-symbol-xmas20.el,v 3.3 1999/01/18 14:17:37 wedler Exp wedler $
;; Keywords: WYSIWYG, LaTeX, HTML, wp, math, internationalization
;; X-URL: http://www.fmi.uni-passau.de/~wedler/x-symbol/

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; If you want to use package x-symbol, please visit the URL (use
;; \\[x-symbol-package-web]) and read the info (use \\[x-symbol-package-info]).

;;; Code:

(provide 'x-symbol-xmas20)


;;;===========================================================================
;;;  Autoloads
;;;===========================================================================

(autoload 'browse-url "browse-url" nil t)


;;;===========================================================================
;;;  Fixing non X-Symbol induced annoyances
;;;===========================================================================

(defun x-symbol-paren-reset-mode ()
  (make-local-variable 'paren-mode)
  (setq paren-mode nil))
(add-hook 'list-mode-hook 'x-symbol-paren-reset-mode)


;;;===========================================================================
;;;  Bug workarounds
;;;===========================================================================

;; Workaround for XEmacs bug (since XEmacs-20) with char syntax `inherit': the
;; following should be executed before(!) the AucTeX's syntax table is created.
(unless (featurep 'mule)
  (modify-syntax-entry ?\237 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\236 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\235 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\234 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\233 "\\" (standard-syntax-table))
  (modify-syntax-entry ?\232 "\\" (standard-syntax-table))
  ;; Add appropriately if more csets (fonts) are added.
  )


;;;===========================================================================
;;;  Bug fixes: list-mode (fixed in XEmacs-21.0)
;;;===========================================================================

(defvar x-symbol-list-mode-map
  (let ((map (make-sparse-keymap)))
    (define-key map " " 'x-symbol-list-selected)
    (define-key map "\C-m" 'x-symbol-list-selected)
    (define-key map "q" 'x-symbol-list-bury)
    (define-key map "?" 'x-symbol-list-info)
    (define-key map "i" 'x-symbol-list-info)
    (define-key map "h" 'x-symbol-list-info)
    (define-key map 'button2 'x-symbol-list-mouse-selected)
    (define-key map 'button2up 'undefined)
    (define-key map 'button3 'x-symbol-list-menu-selected)
    (define-key map 'button3up 'undefined)
    ;; XEmacs-20.4 bug fix:
    (substitute-key-definition 'forward-char 'x-symbol-next-list-mode-item
			       map global-map)
    (substitute-key-definition 'backward-char 'x-symbol-previous-list-mode-item
			       map global-map)
    (set-keymap-parent map list-mode-map)
    map))

(defun x-symbol-previous-list-mode-item (n)
  ;; checkdoc-params: (n)
  "Move to the previous item in `list-mode' (corrected version)."
  (interactive "p")
  (x-symbol-next-list-mode-item (- n)))

(defun x-symbol-next-list-mode-item (n)
  "Move to the next item in `list-mode' (corrected version).
With prefix argument N, move N items (negative N means move backward)."
  (interactive "p")
  (while (and (> n 0) (not (eobp)))
    (let ((extent (extent-at (point) (current-buffer) 'list-mode-item))
	  (end (point-max)))
      ;; If in a completion, move to the end of it.
      (if extent (goto-char (extent-end-position extent)))
      ;; Move to start of next one.
      (or (extent-at (point) (current-buffer) 'list-mode-item)
	  (goto-char (next-single-property-change (point)
						  'list-mode-item nil end))))
    (setq n (1- n)))
  (while (and (< n 0) (not (bobp)))
    (let ((extent (extent-at (point) (current-buffer) 'list-mode-item))
	  (end (point-min)))
      ;; If in a completion, move to the start of it.
      (if extent (goto-char (extent-start-position extent)))
      ;; Move to the start of that one.
      (if (setq extent (extent-at (point) (current-buffer) 'list-mode-item
				  nil 'before))
	  (goto-char (extent-start-position extent))
	(goto-char (previous-single-property-change
		    (point) 'list-mode-item nil end))
	(if (setq extent (extent-at (point) (current-buffer) 'list-mode-item
				    nil 'before)) ; should return t
	    (goto-char (extent-start-position extent)))))
    (setq n (1+ n))))

;;; Local IspellPersDict: .ispell_xsymb
;;; x-symbol-xmas20.el ends here
