/*	$Id: help.c,v 1.11 1997/10/31 20:35:50 sandro Exp $	*/

/*
 * Copyright (c) 1997
 *	Sandro Sigala, Brescia, Italy.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#include <assert.h>
#include <ctype.h>
#include <limits.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "zile.h"
#include "extern.h"
#include "paths.h"
#include "version.h"

DEFUN("zile-version", zile_version)
/*+
Show the zile version.
+*/
{
	minibuf_write("Zile " ZILE_VERSION " of " CONFIGURE_DATE " on " CONFIGURE_HOST);

	return TRUE;
}

DEFUN("toggle-minihelp-window", toggle_minihelp_window)
/*+
Toggle the mini help window.
+*/
{
	char *bname = "*Mini Help*";
	bufferp bp;
	windowp wp;

	if ((wp = find_window(bname)) != NULL) {
		cur_wp = wp;
		cur_bp = wp->bp;
		F_delete_window(1);
	} else {
		if (!exist_file(PATH_DATA "/HELPWIN")) {
			minibuf_error("Unable to read file %FY`%s'%E", PATH_DATA "/HELPWIN");
			return FALSE;
		}

		F_delete_other_windows(1);
		F_split_window(1);
		cur_wp = head_wp;
		if ((bp = find_buffer(bname, FALSE)) == NULL) {
			bp = find_buffer(bname, TRUE);
			bp->flags = BFLAG_NOUNDO | BFLAG_READONLY | BFLAG_NOSAVE | BFLAG_NEEDNAME | BFLAG_TEMPORARY | BFLAG_MODIFIED | BFLAG_NOEOB;
			set_temporary_buffer(bp);
			switch_to_buffer(bp);
			read_from_disk(PATH_DATA "/HELPWIN");
		} else {
			switch_to_buffer(bp);
			gotobob();
		}
		cur_wp = head_wp->next;
		cur_bp = head_wp->next->bp;
		while (head_wp->eheight > head_wp->bp->num_lines + 1)
			F_enlarge_window(1);
	}

	return TRUE;
}

static int
show_file(char *filename)
{
	if (!exist_file(filename)) {
		minibuf_error("Unable to read file %FY`%s'%E", filename);
		return FALSE;
	}

	open_file(filename, 0);
	cur_bp->flags = BFLAG_READONLY | BFLAG_NOSAVE | BFLAG_NEEDNAME | BFLAG_NOUNDO;

	return TRUE;
}

DEFUN("help-latest-version", help_latest_version)
/*+
Show informations about getting the latest version.
+*/
{
	return show_file(PATH_DATA "/LATEST_VERSION");
}

DEFUN("help", help)
/*+
Show an help window.
+*/
{
	return show_file(PATH_DATA "/HELP");
}

DEFUN("help-faq", help_faq)
/*+
Show the Zile Frequently Asked Questions (FAQ).
+*/
{
	return show_file(PATH_DATA "/FAQ");
}

DEFUN("help-tutorial", help_tutorial)
/*+
Show a tutorial window.
+*/
{
	if (show_file(PATH_DATA "/TUTORIAL")) {
		char buf[PATH_MAX];

		cur_bp->flags = 0;
		strcpy(buf, getenv("HOME"));
		strcat(buf, "/TUTORIAL");
		set_buffer_filename(cur_bp, buf);

		return TRUE;
	}

	return FALSE;
}
