/*$Id: bm_cond.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * behavioral modeling conditionals
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
EVAL_BM_COND_BASE* EVAL_BM_COND_BASE::parse_func_type(CS& cmd)
{
  if      (cmd.pmatch("AC"	 )){return new EVAL_BM_COND_AC;}
  else if (cmd.pmatch("DCOP"	 )){return new EVAL_BM_COND_DCOP;}
  else if (cmd.pmatch("DCONLY"	 )){untested();return new EVAL_BM_COND_DCONLY;}
  else if (cmd.pmatch("DCtran"	 )){return new EVAL_BM_COND_DCTRAN;}
  else if (cmd.pmatch("OP"	 )){untested(); return new EVAL_BM_COND_OP;}
  else if (cmd.pmatch("TRANsient")){return new EVAL_BM_COND_TRAN;}
  else if (cmd.pmatch("ELSE"	 )){untested(); return new EVAL_BM_COND_ELSE;}
  else if (cmd.pmatch("END"	 )){untested(); return new EVAL_BM_COND_END;}
  else return 0;
}
/*--------------------------------------------------------------------------*/
EVAL_BM_COND_BASE::EVAL_BM_COND_BASE(int c)
  :EVAL_BM_BASE(c),
   _true(0),
   _false(0)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_COND_BASE::EVAL_BM_COND_BASE(const EVAL_BM_COND_BASE& p) 
  :EVAL_BM_BASE(p),
   _true(p._true),
   _false(p._false)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COND_BASE::parse(CS& cmd)
{
  cmd.stuck();
  {
    EVAL_BM_ACTION_BASE* c = EVAL_BM_ACTION_BASE::parse_func_type(cmd);
    if (!c){
      c = new EVAL_BM_VALUE;
    }
    assert(c);
    c->parse(cmd);
    _true = c->attach();
  }
  {
    EVAL_BM_COND_BASE* c = EVAL_BM_COND_BASE::parse_func_type(cmd);
    if (!c){
      c = new EVAL_BM_COND_END;
    }
    assert(c);
    c->parse(cmd);
    _false = c->attach();
  }

  assert(_true);
  assert(_false);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COND_BASE::print(OMSTREAM where)const
{
  assert(_true);
  assert(_false);
  where << "  " << name();
  _true->print(where);
  _false->print(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COND_END::tr_eval(COMPONENT* d)const
{
  d->y0 = FPOLY1(CPOLY1(d->y0.x, 0, d->value()));
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COND_END::ac_eval(COMPONENT* d)const
{
  untested();
  d->ev = d->value();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
