/*$Id: d_cap.cc,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * capacitor models
 * two levels: linear (lin) and nonlinear (nl)
 * y.x = volts, y.f0 = coulombs, ev = y.f1 = farads
 */
#include "d_cap.h"
/*--------------------------------------------------------------------------*/
bool DEV_CAPACITANCE::do_tr()
{
  initial_condition = NOT_INPUT;
  {if (has_tr_eval()){
    m0.x = y0.x = volts_limited(n[OUT1],n[OUT2]);
    y0.f0 = m0.c1 * m0.x + m0.c0;	/* BUG: WHY?? */
    tr_eval();
  }else{
    m0.x = y0.x = n[OUT1].v0() - n[OUT2].v0();
    assert(y0.f1 == value());
    y0.f0 = y0.x * y0.f1;
    assert(converged());
  }}
  store_values();
  q_load();
  integrate();
  return converged();
}
/*--------------------------------------------------------------------------*/
double DEV_CAPACITANCE::tr_review()
{
  return review(m0.c1 * m0.x + m0.c0, mt1.c1 * mt1.x + mt1.c0);
}
/*--------------------------------------------------------------------------*/
void DEV_CAPACITANCE::do_ac()
{
  {if (has_ac_eval()){
    ac_eval();
  }else{
    assert(ev == y0.f1);
    assert(has_tr_eval() || ev == value());
  }}
  acg = ev * SIM::jomega;
  ac_load_passive();
}
/*--------------------------------------------------------------------------*/
void DEV_CAPACITANCE::integrate()
{
  {if (SIM::mode == sDC  ||  SIM::mode == sOP){
    m0.c0 = m0.c1 = 0.;
  }else{
    assert(SIM::mode == sTRAN || SIM::mode == sFOURIER);
    {if (SIM::phase == pINIT_DC){
      {if (time0 == 0.){
	{if (!SIM::uic){
	  m0.c0 = m0.c1 = 0.;
	}else if (initial_condition != NOT_INPUT){
	  m0.c1 = 1./OPT::shortckt;
	  m0.c0 = -initial_condition * m0.c1;
	}else{
	  untested();
	  m0.c0 = m0.c1 = 0.;
	}}
      }else{
	assert(time0 > 0);
	/* leave it alone to restart from a previous solution */
      }}
    }else{
      assert(SIM::phase == pTRAN);
      double oldv = mt1.x;
      double dt = time0 - time1;
      assert(dt > 0.);
      switch (method_a){
      case mGEAR:
      case mTRAPGEAR:
      case mTRAPEULER:
      case mEULER:{
	m0.c1 = y0.f1 / dt;		    /* first order 	      */
	m0.c0 = -m0.c1 * oldv;		    /* (stiff) (backward Euler) */
	break;
      }
      case mTRAP:{			    /* second order 	     */
	double oldi = mt1.c0 + mt1.c1*oldv; /* (non-stiff) (trapezoid) */
	m0.c1 = 2. * y0.f1 / dt;
	m0.c0 = -m0.c1 * oldv - oldi;
	break;
      }
      }
    }}
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
