/*$Id: d_mos.h,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * data structures and defaults for mos model.
 * internal units all mks (meters)
 * but some user input parameters are in cm.
 */
#ifndef D_MOS_H
#define D_MOS_H
#include "d_diode.h"
#include "e_subckt.h"
/*--------------------------------------------------------------------------*/
class DEV_MOS;			/* this file */
class MOS_COMMON;
class MODEL_MOS_BASE;
class EVAL_MOS_Ids;
class EVAL_MOS_Gmf;
class EVAL_MOS_Gmr;
class EVAL_MOS_Gds;
class EVAL_MOS_Gmbf;
class EVAL_MOS_Gmbr;
class EVAL_MOS_Cgb;
class EVAL_MOS_Cgd;
class EVAL_MOS_Cgs;
/*--------------------------------------------------------------------------*/
class DEV_ADMITTANCE;		/* external */
class DEV_DIODE;
class DEV_CAPACITANCE;
class DEV_CS;
class DEV_RESISTANCE;
class DEV_VCCS;
enum {mNUM_INIT_COND = 3};
/*--------------------------------------------------------------------------*/
enum polarity_t {pP = -1, pN = 1};
/*--------------------------------------------------------------------------*/
class DEV_MOS : public BASE_SUBCKT {
private:
  explicit  DEV_MOS(const DEV_MOS& p);
public:
  explicit  DEV_MOS();
	    ~DEV_MOS()	{--Count;}
private: // override virtual
  CARD*	    clone()const	{return new DEV_MOS(*this);}
  void	    parse(CS&);
  void	    print(OMSTREAM,int)const;
  void	    expand();
  //void    precalc();		//BASE_SUBCKT, wrong

  //void    dc_begin();		//BASE_SUBCKT
  //void    tr_begin();		//BASE_SUBCKT
  //void    tr_restore();	//BASE_SUBCKT
  void      dc_advance()	{set_not_converged(); subckt().dc_advance();}
  void      tr_advance()	{set_not_converged(); subckt().tr_advance();}
  bool	    tr_needs_eval();
  void	    tr_queue_eval()	{if(tr_needs_eval()){q_eval();}}
  bool	    do_tr();
  //void    tr_load();		//BASE_SUBCKT
  //double  tr_review();	//BASE_SUBCKT
  //void    tr_accept();	//BASE_SUBCKT
  //void    tr_unload();	//BASE_SUBCKT
  double    probe_tr_num(const std::string&)const;

  //void    ac_begin();		//BASE_SUBCKT
  //void    do_ac();		//BASE_SUBCKT

  int	    numnodes()const	{return 4;}
public:
  static int count()		{return Count;}
private:
  void	    limit_mos(double,double,double);
public:
  double   ids;		/* iterated parameters, latest		*/
  double   gm;
  double   gds;
  double   gmb;
  //double   cgb;	/* capacitors and charges		*/
  //double   qgb;
  //double   cgd;
  //double   qgd;
  //double   cgs;
  //double   qgs;
  double   vgs;		/* terminal voltages			*/
  double   vds;
  double   vbs;
  double   vdsat;	/* saturation voltage			*/
  double   vgst;	/* vgs - von.				*/
  double   von;		/* actual threshold voltage		*/
  bool     reversed;	/* flag: Vgs < 0, reverse s & d		*/
  bool     cutoff;	/* flag: in cut off region		*/
  bool     subthreshold;/* flag: subthreshold region (L2 only)	*/
  bool     saturated;	/* flag: in saturation region		*/
  bool     sbfwd;	/* flag: sb diode fwd biased		*/
  bool     dbfwd;	/* flag: db diode fwd biased		*/
  bool     punchthru;	/* flag: punch thru region		*/
  polarity_t polarity;	/* N or P channel, from model, for speed*/
  node_t   drainnode;	/* internal drain node			*/
  node_t   sourcenode;	/* internal source node			*/
  DEV_RESISTANCE*  Rs;	/* subckt elements, for probe		*/
  DEV_RESISTANCE*  Rd;
  DEV_DIODE*	   Ddb;
  DEV_DIODE*	   Dsb;
  DEV_CAPACITANCE* Cgs;
  DEV_CAPACITANCE* Cgd;
  DEV_CAPACITANCE* Cgb;
  DEV_VCCS*	   Gmbf;
  DEV_VCCS*	   Gmbr;
  DEV_ADMITTANCE*  Yds;
  DEV_VCCS*	   Gmf;
  DEV_VCCS*	   Gmr;
  DEV_CS*	   Ids;
  static int Count;
};
/*--------------------------------------------------------------------------*/
class MOS_COMMON : public COMPONENT_COMMON {
public:
  explicit	MOS_COMMON(int c=0);
  explicit	MOS_COMMON(const MOS_COMMON& p);
		~MOS_COMMON()		{--Count;}
  void		parse(CS&);
  void		print(OMSTREAM)const;
  const MODEL_MOS_BASE* expand();
  const char*	name()const		{untested(); return "mos";}
  static int	count()			{return Count;}
public:
  double   lo;		/* drawn (optical) channel length	*/
  double   wo;		/* channel width (drawn)		*/
  double   ad_in;	/* drain area, drawn			*/
  double   as_in;	/* source area, drawn			*/
  double   pd;		/* drain perimeter			*/
  double   ps;		/* source perimeter			*/
  double   nrd;		/* drain # squares			*/
  double   nrs;		/* source # squares			*/
  double   ic[mNUM_INIT_COND];	/* initial conditions		*/
  int	   off;		/* off flag				*/
  int	   icset;	/* flag: initial conditions set		*/
   			/* up to here initialized		*/
  double   le;		/* -23-c- actual (electrical) channel length	*/
  double   we;		/* --3-c- actual (electrical) channel width	*/
  double   ad;		/* ----c- drain area, actual			*/
  double   as;		/* ----c- source area, actual			*/
  double   cgate;	/* -----b gate to channel capacitance		*/
  double   relxj; /*?*/ /* -2---- */
  double   eta_1; /*?*/ /* -2---- */
  double   eta;	  /*?*/ /* -2---- */
  double   eta_2; /*?*/ /* -2---- */
  double   idsat; /*?*/	/* -----b drain junction saturation current	*/
  double   issat; /*?*/	/* -----b source junction saturation current	*/
  double   rd;	  /*?*/	/* -----b ohmic drain resistance		*/
  double   rs;	  /*?*/	/* -----b ohmic source resistance		*/
		  /*?*/ /*indicates calculated from other params*/
  DIODE_COMMON sb;
  DIODE_COMMON db;
private:
  static int Count;
};
/*--------------------------------------------------------------------------*/
class MODEL_MOS_BASE : public MODEL_DIODE {
protected:
  explicit	MODEL_MOS_BASE(const MODEL_MOS_BASE& p) 
					:MODEL_DIODE(p) {unreachable();}
public:
  explicit	MODEL_MOS_BASE();
		~MODEL_MOS_BASE()		{--Count;}
  static CARD*	new_model(CS&);

protected:
  void     parse_params_base(CS&);
  void     post_parse_base();
  void	   print_base_begin(OMSTREAM,int)const;
  void	   print_base_mid(OMSTREAM)const;
  void	   print_base_end(OMSTREAM)const;

private:		/* strictly internal */
  static int Count;
public:			/* input parameters */
  double   is;		/* bulk jct sat current */
  double   js;		/* bulk jct sat current per sq meter */

  double   rsh;		/* D & S diffusion sheet resistance */
  double   rd;		/* drain ohmic resistance */
  double   rs;		/* source ohmic resistance */
  double   cbd;		/* 0-bias BD jct capacitance */
  double   cbs;		/* 0-bias BS jct capacitance */
  double   cgso;	/* GS overlap capacitance */
  double   cgdo;	/* GD overlap capacitance */
  double   cgbo;	/* GB overlap capacitance */
protected:
  bool	   calc_cj;
public:
  polarity_t polarity;	/* N or P channel */

public:			/* simple data access */
  static int count()		{return Count;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Ids : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Ids(const EVAL_MOS_Ids& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Ids(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Ids";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Gmf : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Gmf(const EVAL_MOS_Gmf& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Gmf(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Gmf";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Gmr : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Gmr(const EVAL_MOS_Gmr& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Gmr(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Gmr";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Gds : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Gds(const EVAL_MOS_Gds& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Gds(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Gds";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Gmbf : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Gmbf(const EVAL_MOS_Gmbf& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Gmbf(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Gmbf";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Gmbr : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Gmbr(const EVAL_MOS_Gmbr& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Gmbr(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Gmbr";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Cgb : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Cgb(const EVAL_MOS_Cgb& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Cgb(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Cgb";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Cgd : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Cgd(const EVAL_MOS_Cgd& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Cgd(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Cgd";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Cgs : public COMPONENT_COMMON {
private:
  explicit EVAL_MOS_Cgs(const EVAL_MOS_Cgs& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_MOS_Cgs(int c=0) :COMPONENT_COMMON(c) {}
  const char* name()const	 {untested(); return "EVAL_MOS_Cgs";}
  void	tr_eval(COMPONENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
/* dimension conversions.
 * All internal distances are in meters.
 * In some cases the user data is in other units
 */
#define CM2M	(1e-2)			/*	centimeters to meters 	 */
#define CM2M2	(1e-4)			/*          ...........  squared */
#define ICM2M	(1e2)			/* inverse  ...........    	 */
#define ICM2M2	(1e4)			/* inverse  ...........  squared */
#define ICM2M3	(1e6)			/* inverse  ...........  cubed   */
#define MICRON2METER	(1e-6)		/*	microns to meters	 */
/*--------------------------------------------------------------------------*/
#define NI	(1.45e16)		/* intrinsic carrier concentration */

#define nDRAIN	n[0]	/* nodes */
#define	nGATE	n[1]
#define nSOURCE	n[2]
#define	nBULK	n[3]

#define mDEFAULT_is		1e-14	/* last resort defaults */
					/* in case can't calculate */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
