/*$Id: d_mos1.cc,v 15.10 1999/10/11 06:30:33 al Exp $ -*- C++ -*-
 * mos model equations: spice level 1 equivalent
 */
#include "d_mos1.h"
/*--------------------------------------------------------------------------*/
//		MODEL_MOS1::MODEL_MOS1()
//	void	MODEL_MOS1::parse_params(CS& cmd)
//	void	MODEL_MOS1::post_parse()
//	void	MODEL_MOS1::print(OMSTREAM where, int)const
//	void	MODEL_MOS1::tr_eval(COMPONENT*)const;
/*--------------------------------------------------------------------------*/
MODEL_MOS1::MODEL_MOS1()
{
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS1::parse_params(CS& cmd)
{
  parse_params_123(cmd);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS1::post_parse()
{
  post_parse_123();
  if (cox == NOT_INPUT){
    untested();
    cox = 0.;
  }
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS1::print(OMSTREAM where, int)const
{
  print_123_begin(where,LEVEL);
  print_123_mid(where);
  print_123_end(where);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS1::tr_eval(COMPONENT* brh)const
{
  DEV_MOS* d = prechecked_cast<DEV_MOS*>(brh);
  assert(d);
  const MOS_COMMON* c = prechecked_cast<const MOS_COMMON*>(d->common());
  assert(c);
  const MODEL_MOS1* m = this;
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */ 
  trace1(d->long_label(), d->evaliter());
  trace3("", d->vds, d->vgs, d->vbs);
  assert(m->_tnom > 0);
  assert(m->egap != NOT_VALID);
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */ 
  double temp = SIM::temp;
  double tempratio  = temp / m->_tnom; // ratio
  double tempratio4 = tempratio * sqrt(tempratio);
  double vt = temp * K / Q;
  double kt = temp * K;
  double t_egap = 1.16 - (7.02e-4*temp*temp) / (temp+1108.);

  double arg = (m->egap*tempratio - t_egap) / (2*kt);
  double pfcf = -2*vt * (1.5*log(tempratio) + Q*(arg));
  double t_phi = m->phi * tempratio + pfcf; //?????????
  double t_sqrt_phi = sqrt(t_phi);
  double t_kp   = m->kp * tempratio4;
  double t_beta = t_kp * c->we / c->le;
  trace4("T", t_phi, t_kp, t_beta, t_vbi);
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */ 
  double sarg, dsarg_dvbs;
  {
    if (d->vbs <= 0.){
      sarg = sqrt(t_phi - d->vbs);
      dsarg_dvbs = -.5 / sarg;
      d->sbfwd = false;
      trace2("sb-ok", sarg, dsarg_dvbs);
    }else{
      untested();
      sarg = t_sqrt_phi / (1. + .5 * d->vbs / t_phi);
      dsarg_dvbs = -.5 * sarg * sarg / t_phi*t_sqrt_phi; /* is wrong!! */
      d->sbfwd = true;
      trace2("***sb-reversed***", sarg, dsarg_dvbs);
    }
  }
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */ 
  {
    if (d->vbs - d->vds <= 0.){
      d->dbfwd = false;
    }else{
      untested();
      d->dbfwd = true;
    }
  }
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */ 
  d->von = m->vto + m->gamma * (sarg - t_sqrt_phi);
  d->vgst = d->vdsat = d->vgs - d->von;
  if (d->vdsat < 0.){
    d->vdsat = 0.;
  }
  d->cutoff = (d->vgst < 0.);
  d->saturated = (d->vds > d->vdsat);
  trace3("", d->von, d->vgst, d->vdsat);
  double Lambda = (m->lambda != NOT_INPUT) ? m->lambda : 0.;
  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */ 
  if (d->cutoff){
    d->gds = d->gm = d->ids = d->gmb = 0.;
    trace4("cut", d->ids, d->gm, d->gds, d->gmb);
  }else if (d->saturated){
    d->gm  = t_beta * d->vgst * (1. + Lambda * d->vds);
    d->ids = d->gm * (.5 * d->vgst);
    d->gds = .5 * t_beta * Lambda * d->vgst * d->vgst;
    d->gmb = - d->gm * m->gamma * dsarg_dvbs;
    trace4("sat", d->ids, d->gm, d->gds, d->gmb);
  }else{ /* linear */
    d->gm  = t_beta * d->vds * (1. + Lambda * d->vds);
    d->ids = d->gm * (d->vgst - .5*d->vds);
    d->gds = t_beta * ((d->vgst - d->vds) 
    		     + Lambda * d->vds * (2.*d->vgst - 1.5*d->vds));
    d->gmb = -d->gm * m->gamma * dsarg_dvbs;
    trace4("lin", d->ids, d->gm, d->gds, d->gmb);
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
