/*$Id: d_mos123.cc,v 15.3 1999/09/17 17:27:00 al Exp $ -*- C++ -*-
 * mos model basics
 * netlist syntax:
 * device:  mxxxx d g s b mname <device args> <model card args>
 * model:   .model mname NMOS <args>
 *	or  .model mname PMOS <args>
 */
#include "ap.h"
#include "d_mos123.h"
/*--------------------------------------------------------------------------*/
//	MODEL_MOS123::MODEL_MOS123();
// void	MODEL_MOS123::parse_params_123(CS& cmd)
// void MODEL_MOS123::post_parse_123()
// void	MODEL_MOS123::parse(CS& cmd);
// void MODEL_MOS123::print_123_begin(OMSTREAM where, int level)const
// void MODEL_MOS123::print_123_mid(OMSTREAM where)const
/*--------------------------------------------------------------------------*/
const double DEFAULT_vto   = 0.0;		/* last resort defaults */
const double DEFAULT_gamma = 0.0;		/* in case can't calculate */
const double DEFAULT_phi   = 0.6;
const double DEFAULT_cj    = 0.0;
const double DEFAULT_nss   = 0.0;
const double DEFAULT_kp	   = 2e-5;
/*--------------------------------------------------------------------------*/
MODEL_MOS123::MODEL_MOS123()
{
  vto    = NOT_INPUT;	/*calc*/
  kp     = NOT_INPUT;	/*calc*/
  gamma  = NOT_INPUT;	/*calc*/
  phi    = NOT_INPUT;	/*calc*/
  lambda = NOT_INPUT;
  tox    = NOT_INPUT;
  nsub   = NOT_INPUT;	/*flag*/
  nss    = DEFAULT_nss;
  xj     = NOT_INPUT;
  ld     = 0.0;
  uo     = (600.*CM2M2);
  delta  = 0.0;
  tpg    = gSAME;
  cmodel = 2;

  egap   = NOT_VALID;
  vfb    = NOT_INPUT;
  vbi    = NOT_INPUT;
  sqrt_phi = NOT_INPUT;
  phi_sqrt_phi = NOT_INPUT;
  cox    = NOT_INPUT;
  calc.vto = calc.kp = calc.gamma = calc.phi = false;
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::parse_params_123(CS& cmd)
{
  parse_params_base(cmd);
  cmd.get("VTO",    &vto,	mSCALE, static_cast<double>(polarity));
  cmd.get("KP",     &kp);
  cmd.get("GAmma",  &gamma);
  cmd.get("PHI",    &phi,	mPOSITIVE);
  cmd.get("LAmbda", &lambda);
  cmd.get("TOX",    &tox,	mPOSITIVE);
  cmd.get("NSUb",   &nsub,	mSCALE, ICM2M3);
  cmd.get("NSS",    &nss,	mSCALE, ICM2M2);
  cmd.get("TPG",    &tpg);
  cmd.get("XJ",     &xj,	mPOSITIVE);
  cmd.get("LD",     &ld);
  cmd.get("UO",     &uo,	mSCALE, CM2M2);
  cmd.get("DELta",  &delta);
  cmd.get("CMODEL", &cmodel);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::post_parse_123()
{
  post_parse_base();
  
  if (_tnom == NOT_INPUT){
    untested();
    _tnom = OPT::tnom;
  }
  assert(_tnom > 0);
  egap = 1.16 - (7.02e-4*_tnom*_tnom) / (_tnom+1108.);

  {if (tpg < 0){	/* user error cover */
    tpg = gOPP;		/* coerce tpg to a proper value */
  }else if (tpg > 0){
    tpg = gSAME;
  }else{
    assert(tpg == gMETAL);
  }}
  if (cmodel != 3){
    cmodel = 2;
  }

  if (tox > 0.){
    cox = E_OX / tox;
    if (kp == NOT_INPUT){
      kp = uo * cox;
      calc.kp = true;
    }
    
    if (nsub != NOT_INPUT){
      nsub = fabs(nsub);
      if (nsub < NI){
	untested();
	error(bWARNING, long_label() + ": nsub < ni\n");
	nsub = NI;
      }
      if (cjo == NOT_INPUT){
	cjo = sqrt(E_SI * Q * nsub / (2. * pb ));
	calc_cj = true;
      }
      if (phi == NOT_INPUT){
	phi = (2.*K/Q) * _tnom * log(nsub/NI);
	if (phi < .1){
	  untested();
	  error(bWARNING,
		long_label() + ": calculated phi too small, using .1\n");
	  phi = .1;
	}
	calc.phi = true;
      }
      if (gamma == NOT_INPUT){
	gamma = sqrt(2. * E_SI * Q * nsub) / cox;
	calc.gamma = true;
      }
      if (vto == NOT_INPUT){
	double phi_ms = (tpg == gMETAL)
	  ? -.05 - (egap + polarity * phi) / 2.
	  : -polarity * (tpg * egap + phi) / 2.;
	
	vfb = phi_ms - Q * nss / cox;
	vto = vfb + polarity * (phi + gamma * sqrt(phi));
	calc.vto = true;
      }
    }
  }

  if (kp == NOT_INPUT){
    kp = DEFAULT_kp;
  }
  if (vto == NOT_INPUT){
    vto = DEFAULT_vto;
  }
  if (gamma == NOT_INPUT){
    gamma = DEFAULT_gamma;
  }
  if (phi == NOT_INPUT){
    phi = DEFAULT_phi;
  }
  if (cjo == NOT_INPUT){
    cjo = DEFAULT_cj;
  }

  sqrt_phi = sqrt(phi);
  phi_sqrt_phi = phi * sqrt_phi;
  if (vfb == NOT_INPUT){
    vfb = vto - (phi + gamma * sqrt_phi);
  }
  vbi = vfb + phi;

  if (lambda != NOT_INPUT  &&  lambda > .2){
    untested();
    error(bWARNING, long_label() + ": lambda too large (> .2)\n");
  }
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::parse(CS& cmd)
{
  cmd.skiparg();	/* skip known ".model" */
  parse_label(cmd);
  cmd.stuck();
  /**/ set(cmd, "NMos", &polarity, pN)
    || set(cmd, "PMos", &polarity, pP);
  if (cmd.stuck()){
    untested();
    cmd.check(bWARNING, "need nmos or pmos");
  }
  cmd.skiplparen();
  cmd.stuck();

  do{
    parse_params(cmd);
  }while (cmd.more() && !cmd.stuck());
  cmd.skiprparen();
  cmd.check(bWARNING, "what's this?");

  post_parse();
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::print_123_begin(OMSTREAM where, int level)const
{
  print_base_begin(where, level);

  if (!calc.vto)
    where << "  vto="	<< vto*polarity;
  if (!calc.kp)
    where << "  kp="	<< kp;
  if (!calc.gamma)
    where << "  gamma="	<< gamma;
  if (!calc.phi)
    where << "  phi="	<< phi;
  if (lambda != NOT_INPUT)
    where << "  lambda="<< lambda;
  if (tox != NOT_INPUT)
    where << "  tox="	<< tox;
  if (nsub != NOT_INPUT)
    where << "  nsub="	<< nsub/ICM2M3;
  if (nss != DEFAULT_nss  ||  nsub != NOT_INPUT)
    where << "  nss="	<< nss /ICM2M2;
  if (xj != NOT_INPUT)
    where << "  xj="	<< xj;
  where   << "  ld="	<< ld;
  where   << "  uo="	<< uo   /CM2M2;
  where   << "  delta="	<< delta;
  where   << "  tpg="   << tpg;
  where	  << "  cmodel="<< cmodel;
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::print_123_mid(OMSTREAM where)const
{
  print_base_mid(where);
  where   << "* vfb="	<< vfb;
  if (calc.vto)
    where << "* vto="	<< vto*polarity;
  if (calc.kp)
    where << "* kp="	<< kp;
  if (calc.gamma)
    where << "* gamma="	<< gamma;
  if (calc.phi)
    where << "* phi="	<< phi;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
