
#ifndef IIRBASE_DYADIC_OPERATOR_HH
#define IIRBASE_DYADIC_OPERATOR_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_DyadicOperator.hh,v 1.2 1999/03/09 20:49:42 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_Operator.hh"

class IIR_SubprogramDeclaration;

class IIRBase_DyadicOperator : public IIRScram_Operator {

public:
  IIR_Kind get_kind() = 0;
  
  IIR_Char *get_kind_text() {return "IIR_DyadicOperator";}

  void set_implementation( IIR_SubprogramDeclaration *implementation );
  IIR_SubprogramDeclaration *get_implementation();

  void set_left_operand( IIR *left_operand );
  IIR *get_left_operand();

  void set_right_operand( IIR *right_operand );
  IIR *get_right_operand();

protected:
  IIRBase_DyadicOperator();
  virtual ~IIRBase_DyadicOperator() = 0;
    
private:
  IIR_SubprogramDeclaration *implementation;
  IIR *left_operand;
  IIR *right_operand;
};
#endif
