// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_Elsif.cc,v 1.2 1999/03/09 20:49:45 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "savant.hh"
#include "IIRBase_Elsif.hh"
#include "IIR_Elsif.hh"

class IIR_Elsif;

IIRBase_Elsif::IIRBase_Elsif() {
  set_condition(NULL);
  set_else_clause(NULL);
}

IIRBase_Elsif::~IIRBase_Elsif() {
  if (condition != NULL) { delete condition; }
  if (else_clause != NULL) { delete else_clause; }
}

void
IIRBase_Elsif::set_condition( IIR* condition) {
  this->condition = condition;
}

IIR*
IIRBase_Elsif::get_condition() {
  return condition;
}

void
IIRBase_Elsif::set_else_clause( IIR_Elsif* else_clause) {
  this->else_clause = else_clause;
}

IIR_Elsif*
IIRBase_Elsif::get_else_clause() {
  return else_clause;
}

