// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_PortList.cc,v 1.2 1999/03/09 20:51:20 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_PortList.hh"
#include "IIR_SignalInterfaceDeclaration.hh"

IIRBase_PortList::IIRBase_PortList() {}
IIRBase_PortList::~IIRBase_PortList() {}


void
IIRBase_PortList::prepend( IIR_SignalInterfaceDeclaration *element ) {

  ASSERT( element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );

  IIR_InterfaceList::prepend( element );
}


void
IIRBase_PortList::append( IIR_SignalInterfaceDeclaration *element ) {

  ASSERT( element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );

  IIR_InterfaceList::append( element );
}


void  
IIRBase_PortList::insert_after( IIR_SignalInterfaceDeclaration *existing_element,
				IIR_SignalInterfaceDeclaration *new_element) {

  ASSERT( existing_element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );
  ASSERT( new_element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );  

  IIR_InterfaceList::insert_after( existing_element, new_element );
}


IIR_Boolean
IIRBase_PortList::insert_before_element( IIR_SignalInterfaceDeclaration* existing_element,
					 IIR_SignalInterfaceDeclaration* new_element) {

  _report_undefined_scram_fn("IIRBase_PortList::insert_before_element");

  return false;
}


void 
IIRBase_PortList::remove( IIR_SignalInterfaceDeclaration *element) {
  ASSERT( element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );

  IIR_InterfaceList::remove( element );
}


IIR_SignalInterfaceDeclaration*
IIRBase_PortList::successor( IIR_SignalInterfaceDeclaration *existing_element ){
  ASSERT( existing_element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );
  
  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::successor( existing_element );

  ASSERT( retval == NULL || retval->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );

  return (IIR_SignalInterfaceDeclaration*)retval;
}


IIR_SignalInterfaceDeclaration*
IIRBase_PortList::predecessor( IIR_SignalInterfaceDeclaration *element ){
  ASSERT( element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );
  
  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::predecessor( element );

  ASSERT( retval == NULL || retval->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );

  return (IIR_SignalInterfaceDeclaration*)retval;
}


IIR_SignalInterfaceDeclaration*
IIRBase_PortList::first( ) {
  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::first( );

  ASSERT( retval == NULL || retval->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );

  return (IIR_SignalInterfaceDeclaration*)retval;
}


IIR_SignalInterfaceDeclaration*
IIRBase_PortList::last() {
  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::last( );

  ASSERT( retval == NULL || retval->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );

  return (IIR_SignalInterfaceDeclaration*)retval;
}


IIR_Int32
IIRBase_PortList::get_position( IIR_SignalInterfaceDeclaration *element ) {
  ASSERT( element->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION );

  return IIR_InterfaceList::get_position( element );
}
