// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AscendingAttribute.cc,v 1.2 1999/03/09 20:52:55 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_AscendingAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "resolution_func.hh"
#include "IIR_EnumerationTypeDefinition.hh"
#include "StandardPackage.hh"

IIRScram_AscendingAttribute::~IIRScram_AscendingAttribute() {}

void 
IIRScram_AscendingAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'ASCENDING ";
}

void 
IIRScram_AscendingAttribute::_publish_cc() {
  _publish_cc_type_attribute("ASCENDING");
}

IIR_TextLiteral *
IIRScram_AscendingAttribute::_build_attribute_name() {
  char *name = "ascending";
  return IIR_Identifier::get( name, strlen(name) );
}

void 
IIRScram_AscendingAttribute::_resolve_suffix_special(){
  _resolve_suffix_local_static_int();
}

IIR_TypeDefinition *
IIRScram_AscendingAttribute::_get_subtype(){
  return StandardPackage::boolean_type;
}

IIR_Declaration *
IIRScram_AscendingAttribute::_get_implicit_declaration( char *name,
							IIR_TypeDefinition *type ){
  return _build_constant_declaration( name, type );
}
