#ifndef IIRSCRAM_CONCURRENT_STATEMENT_HH
#define IIRSCRAM_CONCURRENT_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConcurrentStatement.hh,v 1.3 1999/04/12 18:18:47 ssubrama Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ConcurrentStatement.hh"
#include "IIR_AssociationList.hh"

class IIR_SignalDeclaration;

class IIRScram_ConcurrentStatement : public IIRBase_ConcurrentStatement {
public:
  IIR_Char* enclosing_path;

  IIR  *_transmute();

  void _publish_cc();
  void _publish_cc_scoping_prefix(IIR *, IIR *, ostream & = _cc_out);
  void _publish_cc_state();
  virtual void _publish_cc_binding_name(ostream& outstream = _cc_out);
  virtual void _publish_cc_concurrent_stmt_init(IIR_DeclarationList* );
  virtual void _publish_cc_instantiate_call();
  virtual void _publish_createNetInfo();
  virtual void _publish_cc_type_info();
  virtual void _publish_cc_extern_type_info();
  void _publish_cc_headerfiles_for_cc_generate_statement();
#ifdef PROCESS_GRAPH
  virtual void _publish_cc_driver_info();
#endif

  virtual IIR* get_instantiated_unit() {
    _report_undefined_scram_fn("get_instantiated_unit()");
    return NULL;
  };

  virtual IIR_AssociationList *_get_generic_map_aspect() {
    if(_is_concurrent_generate_statement() == TRUE) {
      return NULL;
    }
    else {
      _report_undefined_scram_fn("_get_generic_map_aspect()");
      return NULL;
    }
  }
  
  IIR_Boolean _is_concurrent_statement() { return TRUE; }

  void _set_enclosing_scope(IIR *);
  IIR* _get_enclosing_scope();
  
  // This method is overriden by classes that can contain instantiate
  // statements.
  virtual void _type_check_instantiate_statements(){ }

  // This method should be overloaded by statements that contain concurrent
  // statement lists.  Currently it's overloaded for concurrent generate for
  // and concurrent generate if statements only.
  IIR_ConcurrentStatementList *_get_concurrent_statment_list(){ return NULL; }

protected:
  IIR* enclosingRegion;

  IIRScram_ConcurrentStatement();
  virtual ~IIRScram_ConcurrentStatement() = 0;
  IIR_Char* _get_enclosing_stmt_to_architecture_path();
  void _publish_cc_enclosing_stmt_to_architecture_path(ostream& outstream = _cc_out);
  
  virtual void _set_guard_signal( IIR_SignalDeclaration * );
  virtual void _resolve_guard_signal( symbol_table * );

private:
};
#endif
