#ifndef IIRSCRAM_DESIGNATORLIST_HH
#define IIRSCRAM_DESIGNATORLIST_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_DesignatorList.hh,v 1.2 1999/03/09 20:54:03 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_DesignatorList.hh"

template <class type> class set;
class IIR_StatementList;
class IIR_Label;
class IIR_TextLiteral;

class IIRScram_DesignatorList : public IIRBase_DesignatorList {

public:  
  void _publish_vhdl(ostream &);
  void _publish_cc_elements();

  void _add_decl_into_cgen_symbol_table();
  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _add_signals_to_sensitivity_list(IIR_DesignatorList* sensitivity_list);

  void _type_check_as_instantiation_list( IIR *instantiated_unit, 
					  IIR_List &,
					  IIR *configuration );

  // This method walks the designator list, looking for a label for an
  // instantiate statement that instantiates "instantiated_unit".  When
  // finding one, it returns the label.
  IIR_Label *_process_instantiate_statement( IIR_Declaration *instantiated_unit,
					     IIR *statement );

  IIR_Boolean _is_component_in_the_list(IIR_TextLiteral* component_name);
protected:
  IIRScram_DesignatorList() {}
  virtual ~IIRScram_DesignatorList() = 0;
    
private:
  void _process_by_all_or_others( IIR_Declaration *instantiated_unit,
				  IIR_List &,
				  IIR_Boolean by_all,
				  IIR *configuration );

  void _process_explicit_list( IIR_Declaration *instantiated_unit, 
			       IIR_List &,
			       IIR *configuration );    
};
#endif
