// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_DyadicOperator.cc,v 1.4 1999/07/23 21:08:03 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_DyadicOperator.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_FunctionCall.hh"
#include "IIR_SubprogramDeclaration.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"

IIRScram_DyadicOperator::~IIRScram_DyadicOperator() {}


char *
IIRScram_DyadicOperator::_get_function_name() {
  char *retval;

  switch ( get_kind() ){
  case IIR_AND_OPERATOR:{
    retval = "\"and\"";
    break;
  }

  case IIR_OR_OPERATOR:{
    retval = "\"or\"";
    break;
  }

  case IIR_NAND_OPERATOR:{
    retval = "\"nand\"";
    break;
  }

  case IIR_NOR_OPERATOR:{
    retval = "\"nor\"";
    break;
  }

  case IIR_XOR_OPERATOR:{
    retval = "\"xor\"";
    break;
  }

  case IIR_XNOR_OPERATOR:{
    retval = "\"xnor\"";
    break;
  }

  case IIR_EQUALITY_OPERATOR:{
    retval = "\"=\"";
    break;
  }

  case IIR_INEQUALITY_OPERATOR:{
    retval = "\"/=\"";
    break;
  }

  case IIR_LESS_THAN_OPERATOR:{
    retval = "\"<\"";
    break;
  }

  case IIR_LESS_THAN_OR_EQUAL_OPERATOR:{
    retval = "\"<=\"";
    break;
  }

  case IIR_GREATER_THAN_OPERATOR:{
    retval = "\">\"";
    break;
  }

  case IIR_GREATER_THAN_OR_EQUAL_OPERATOR:{
    retval = "\">=\"";
    break;
  }

  case IIR_SLL_OPERATOR:{
    retval = "\"sll\"";
    break;
  }

  case IIR_SLA_OPERATOR:{
    retval = "\"sla\"";
    break;
  }

  case IIR_SRL_OPERATOR:{
    retval = "\"srl\"";
    break;
  }

  case IIR_SRA_OPERATOR:{
    retval = "\"sra\"";
    break;
  }

  case IIR_ROL_OPERATOR:{
    retval = "\"rol\"";
    break;
  }

  case IIR_ROR_OPERATOR:{
    retval = "\"ror\"";
    break;
  }

  case IIR_ADDITION_OPERATOR:{
    retval = "\"+\"";
    break;
  }

  case IIR_SUBTRACTION_OPERATOR:{
    retval = "\"-\"";
    break;
  }

  case IIR_CONCATENATION_OPERATOR:{
    retval = "\"&\"";
    break;
  }

  case IIR_MULTIPLICATION_OPERATOR:{
    retval = "\"*\"";
    break;
  }

  case IIR_DIVISION_OPERATOR:{
    retval = "\"/\"";
    break;
  }

  case IIR_MODULUS_OPERATOR:{
    retval = "\"mod\"";
    break;
  }  

  case IIR_REMAINDER_OPERATOR:{
    retval = "\"rem\"";
    break;
  }  

  case IIR_EXPONENTIATION_OPERATOR:{
    retval = "\"**\"";
    break;
  }  

  default:{
    cerr << "Unknown operator type in IIRScram_DyadicOperator::_get_function_name()" << endl;
    abort();
  }
  }

  return retval;
}


IIR_Boolean
IIRScram_DyadicOperator::_is_short_circuit() {
  ASSERT(get_subtype() != NULL);
  if( ((get_kind() == IIR_AND_OPERATOR)  ||
       (get_kind() == IIR_NAND_OPERATOR) ||
       (get_kind() == IIR_NOR_OPERATOR)  ||
       (get_kind() == IIR_OR_OPERATOR)) && ( get_subtype()->_is_bit_type() || 
					     get_subtype()->_is_boolean_type())
      ) {
    return TRUE;
  }
  else {
    return FALSE;
  }
}


IIR * 
IIRScram_DyadicOperator::_transmute() {
  IIR_FunctionCall* functioncall = new IIR_FunctionCall;
  IIR_AssociationElementByExpression* associationelement;

  copy_location( this, functioncall );
  functioncall->set_implementation(get_implementation());

  associationelement = new IIR_AssociationElementByExpression;
  copy_location( this, associationelement );
  associationelement->set_actual(get_left_operand());
  functioncall->parameter_association_list.append(associationelement);

  associationelement = new IIR_AssociationElementByExpression;
  copy_location( this, associationelement );
  associationelement->set_actual(get_right_operand());
  functioncall->parameter_association_list.append(associationelement);

  return functioncall;
}


IIR_AssociationList *
IIRScram_DyadicOperator::_build_argument_list(){
  IIR_AssociationList *retval = new IIR_AssociationList;
  //  copy_location( this, retval );
  
  IIR_AssociationElementByExpression *new_assoc = new IIR_AssociationElementByExpression();
  copy_location( get_left_operand(), new_assoc );
  new_assoc->set_actual( get_left_operand() );
  retval->append( new_assoc );

  new_assoc = new IIR_AssociationElementByExpression();
  copy_location( get_right_operand(), new_assoc );
  new_assoc->set_actual( get_right_operand() );
  retval->append( new_assoc );

  return retval;
}


void
IIRScram_DyadicOperator::_publish_cc_headers() {
  ASSERT(get_left_operand() != NULL);
  ASSERT(get_right_operand() != NULL);
  get_left_operand()->_publish_cc_headers();
  get_right_operand()->_publish_cc_headers();
}


void
IIRScram_DyadicOperator::_publish_cc_operator_name() {
  _report_undefined_scram_fn("_publish_cc_operator_name");
}


void
IIRScram_DyadicOperator::_publish_cc_short_circuit() {
  _report_undefined_scram_fn("_publish_cc_short_circuit");
}


void
IIRScram_DyadicOperator::_publish_cc_wait_data_short_circuit() {
  _report_undefined_scram_fn("_publish_cc_wait_data_short_circuit");
}


void
IIRScram_DyadicOperator::_publish_cc() {
  if(_is_short_circuit()) {
    _publish_cc_short_circuit();
  }
  else {
    _publish_cc_operator_name();
    _cc_out << "(";
    get_left_operand()->_publish_cc();
    _cc_out << ", ";
    get_right_operand()->_publish_cc();
    _cc_out << ")";
  }
}


void
IIRScram_DyadicOperator::_publish_cc_initialization_value() {
  _publish_cc();
}


void
IIRScram_DyadicOperator::_publish_cc_wait_data() {
  if(_is_short_circuit()) {
    _publish_cc_wait_data_short_circuit();
  }
  else {
    _publish_cc_operator_name();
    _cc_out << "(";
    get_left_operand()->_publish_cc_wait_data();
    _cc_out << ", ";
    get_right_operand()->_publish_cc_wait_data();
    _cc_out << ")";
  }
}
  

void
IIRScram_DyadicOperator::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  get_left_operand()->_get_list_of_input_signals(list);
  get_right_operand()->_get_list_of_input_signals(list);
}


void
IIRScram_DyadicOperator::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  get_left_operand()->_build_sensitivity_list(sensitivity_list);
  get_right_operand()->_build_sensitivity_list(sensitivity_list);
}


IIR_Boolean 
IIRScram_DyadicOperator::_is_resolved(){
  if( get_implementation() != NULL && get_implementation()->_is_resolved() == FALSE ){
    return FALSE;
  }

  ASSERT( get_left_operand() != NULL );
  ASSERT( get_right_operand() != NULL );

  if( get_left_operand()->_is_resolved() == TRUE 
      && get_right_operand()->_is_resolved() == TRUE
      && get_subtype() != NULL ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}


void 
IIRScram_DyadicOperator::_add_decl_into_cgen_symbol_table() {
  get_left_operand()->_add_decl_into_cgen_symbol_table();
  get_right_operand()->_add_decl_into_cgen_symbol_table();
}


void
IIRScram_DyadicOperator::_clone(IIRScram_DyadicOperator *clone) {
  IIR *cloneop;

  IIR_Expression::_clone(clone);
  clone->set_implementation(get_implementation());
  cloneop = get_left_operand()->_clone();
  clone->set_left_operand(cloneop);
  cloneop = get_right_operand()->_clone();
  clone->set_right_operand(cloneop);
}


IIR_Boolean
IIRScram_DyadicOperator::_is_static_expression() {
  if ((get_left_operand()->_is_static_expression() == TRUE) &&
      (get_right_operand()->_is_static_expression() == TRUE)) {
    return TRUE;
  }
  return FALSE;
}


IIR_Boolean
IIRScram_DyadicOperator::_is_operator() { return TRUE; }

IIR_Boolean
IIRScram_DyadicOperator::_is_locally_static_primary() {
  ASSERT( _is_resolved() == TRUE );

  if ( get_left_operand()->_is_locally_static_primary() == TRUE &&
       get_right_operand()->_is_locally_static_primary() == TRUE ) {
    return TRUE;
  }
  else{
    return FALSE;
  }
}

void
IIRScram_DyadicOperator::_publish_vhdl(ostream &_vhdl_out){
  bool left_bracket = FALSE;
  bool right_bracket = FALSE ;
  OperatorPrecedenceLevel left_precedence = OTHERS;
  OperatorPrecedenceLevel right_precedence = OTHERS;
  OperatorPrecedenceLevel self_precedence = OTHERS;
  
  left_precedence = get_left_operand()->_get_operator_precedence();
  right_precedence = get_right_operand()->_get_operator_precedence();
  self_precedence = _get_operator_precedence();


  if ((get_left_operand()->_get_subtype() != NULL) && 
      (get_right_operand()->_get_subtype() != NULL)){
    if (((get_left_operand()->_get_subtype())->_is_physical_type() == TRUE )||
	((get_right_operand()->_get_subtype())->_is_physical_type() == TRUE )) {
      _vhdl_out << "(";
    }
  }
  if (( left_precedence < self_precedence ) || (get_left_operand()->_is_relational_operator() == TRUE)){
    left_bracket = TRUE ;
  }
  if (( get_left_operand()->get_kind() == get_kind())  && (_is_left_associative() == FALSE )){
    left_bracket = TRUE ;
  }
  if (( left_precedence == self_precedence ) && ( _is_logical_operator() == TRUE ) && ( get_kind() != get_left_operand()->get_kind() )){
    left_bracket = TRUE ;
  }
  if (( right_precedence < self_precedence ) || (get_right_operand()->_is_relational_operator() == TRUE)){
    right_bracket = TRUE ;
  } 
  if ((right_precedence == self_precedence) && (_is_associative(get_right_operand()->get_kind()) == FALSE)) {
    right_bracket = TRUE;
  }
  if ( left_bracket == TRUE ){
    _vhdl_out << "(";
  }
  get_left_operand()->_publish_vhdl(_vhdl_out);
  if ( left_bracket == TRUE ){
    _vhdl_out << ")";
  }
  _publish_vhdl_operator(_vhdl_out);
  if ( right_bracket == TRUE ){
    _vhdl_out << "(";
  }
  get_right_operand()->_publish_vhdl(_vhdl_out);
  if ( right_bracket == TRUE ){
    _vhdl_out << ")";
  }

  if ((get_left_operand()->_get_subtype() != NULL) && 
      (get_right_operand()->_get_subtype() != NULL)){
    if (((get_left_operand()->_get_subtype())->_is_physical_type() == TRUE )||
	((get_right_operand()->_get_subtype())->_is_physical_type() == TRUE )) {
      _vhdl_out << ")";
    }
  }
}

void 
IIRScram_DyadicOperator::_type_check_operands(){
  ASSERT( get_implementation() != NULL );
  ASSERT( get_implementation()->interface_declarations.num_elements() == 2 );

  IIR_InterfaceDeclaration *first_argument_decl = 
    get_implementation()->interface_declarations.first();
  IIR_InterfaceDeclaration *second_argument_decl = 
    get_implementation()->interface_declarations.successor( first_argument_decl );
  
  IIR_TypeDefinition *left_type = first_argument_decl->get_subtype();
  IIR_TypeDefinition *right_type = second_argument_decl->get_subtype();

  set_left_operand( get_left_operand()->_semantic_transform( left_type ) );
  get_left_operand()->_type_check( left_type );
  set_left_operand( get_left_operand()->_rval_to_decl( left_type ) );

  set_right_operand( get_right_operand()->_semantic_transform( right_type ) );
  get_right_operand()->_type_check( right_type );
  set_right_operand( get_right_operand()->_rval_to_decl( right_type ) );

}

