#ifndef IIRSCRAM_ELEMENT_DECLARATION_HH
#define IIRSCRAM_ELEMENT_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ElementDeclaration.hh,v 1.2 1999/03/09 20:54:10 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ElementDeclaration.hh"
class IIR_Name;
class IIR_List ;

class IIRScram_ElementDeclaration : public IIRBase_ElementDeclaration {

public:

  void _publish_vhdl_decl(ostream &);
  IIR_TypeDefinition *_get_subtype();

  set<IIR_Declaration> *_find_declarations( IIR_Name *to_find );

  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_TypeDefinition> *,
					  IIR_Boolean (IIR::*constraint_function)() = 0 );

  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_Declaration> *,
					  IIR_Boolean (IIR::*constraint_function)() = 0 ); 

  IIR_TypeDefinition *_determine_rval_in_set( set<IIR_TypeDefinition> *, IIR_TypeDefinition * );

  IIR *_rval_to_decl( IIR_TypeDefinition *prefix_rval, IIR_TypeDefinition *suffix_rval );

  IIR_Boolean _is_scalar_type();
  IIR_Boolean _is_array_type();
  IIR_Boolean _is_access_type();

  void _publish_cc_type_name();
  void _publish_cc();
  void _publish_cc_universal_value();
  int _get_field_number();
  void _publish_cc_elaborate();
  
  declaration_type _get_type(){ return ELEMENT; }
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return TRUE; }
  IIR_Boolean _is_element(){ return TRUE; }
  IIR_Boolean _is_iir_element_declaration(){ return TRUE; }

  IIR_TypeDefinition *_get_type_of_element( int );
  IIR_TypeDefinition *_get_rval_pointed_at();

protected:
  IIRScram_ElementDeclaration() {}
  virtual ~IIRScram_ElementDeclaration() = 0;
    
private:
};
#endif
