// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_InterfaceList.cc,v 1.2 1999/03/09 20:55:08 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_InterfaceList.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_TextLiteral.hh"

IIRScram_InterfaceList::~IIRScram_InterfaceList() {}

void 
IIRScram_InterfaceList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_InterfaceDeclaration* interface_element;

  interface_element = first();
  while (interface_element != NULL) {
    interface_element->_publish_vhdl(_vhdl_out);
    interface_element = successor(interface_element);
    if (interface_element != NULL) {
      _vhdl_out << "; ";
    }
  }
}

void 
IIRScram_InterfaceList::_publish_vhdl_decl(ostream &_vhdl_out) {
  IIR_InterfaceDeclaration* interface_element;

  interface_element = first();
  while (interface_element != NULL) {
    interface_element->_publish_vhdl_decl(_vhdl_out);
    interface_element = successor(interface_element);
    if (interface_element != NULL) {
      _vhdl_out << "; ";
    }
  }
}

void
IIRScram_InterfaceList::_publish_cc_decl() {
  IIR_InterfaceDeclaration *interface_element = first();
  
  while(interface_element != NULL) {
    interface_element->_publish_cc_decl();
    interface_element = successor(interface_element);
    if(interface_element != NULL) {
      _cc_out << ", ";
    }
  }
}

void
IIRScram_InterfaceList::_publish_cc_decl_subprogram_args(IIR_Boolean _to_publish_default_argument){
  IIR_InterfaceDeclaration *interface_element = first();
  
  while(interface_element != NULL) {
    interface_element->_publish_cc_decl_subprogram_arg(_to_publish_default_argument);
    interface_element = successor(interface_element);
    if(interface_element != NULL) {
      _cc_out << ", ";
    }
  }
}

void
IIRScram_InterfaceList::_publish_cc_local_parameter_args() {
  IIR_InterfaceDeclaration *interface_element = first();
  
  while(interface_element != NULL) {
    if (interface_element->_get_mode() == IIR_IN_MODE) {
      if (interface_element->_get_subtype()->_is_scalar_type() == TRUE &&
	  interface_element->_get_subtype()->_is_kernel_type() == FALSE){
	interface_element->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
      interface_element->_get_subtype()->_publish_cc_type_name();
      }
      _cc_out << " ";
      interface_element->_get_declarator()->_publish_cc();
      _cc_out << "(";
      interface_element->_get_declarator()->_publish_cc();
      _cc_out << "_in);\n";
    }
    
    interface_element = successor(interface_element);
  }
}

