#ifndef IIRSCRAM_LAST_VALUE_ATTRIBUTE_HH
#define IIRSCRAM_LAST_VALUE_ATTRIBUTE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran  urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LastValueAttribute.hh,v 1.4 1999/10/28 03:24:09 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_LastValueAttribute.hh"

class IIRScram_LastValueAttribute : public IIRBase_LastValueAttribute {
public:
  void _publish_vhdl(ostream &);
  IIR_Boolean _is_signal(){ return FALSE; }
  IIR_TypeDefinition *_get_subtype();
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  IIR_TextLiteral *_build_attribute_name();

  IIR_Declaration *_get_implicit_declaration( char *decl_name, IIR_TypeDefinition *decl_type );

  void _publish_cc();
  void _publish_cc_necessary_decl_in_state();
  void _publish_cc_name_in_caps();
  void _publish_cc_attrib_type();
  void _publish_cc_neccessary_decl_init();
  void _publish_cc_init_val();
  void _publish_cc_elaborate();
  void _publish_cc_sigtype();
  void _publish_cc_state_object_init();
  void _publish_cc_init();  
  void _publish_cc_necessary_copying();
  void _publish_cc_read_or_write(const char *, const char *);
  virtual IIR *_clone();
  
  IIR_Boolean _is_lastvalue_attribute() { return TRUE; }
  IIR_Boolean _is_function_attribute(){ return TRUE; }

protected:
  IIRScram_LastValueAttribute() {}
  virtual ~IIRScram_LastValueAttribute() = 0;
    
private:
};
#endif
