// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LibraryUnitList.cc,v 1.3 1999/03/30 02:56:13 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_LibraryUnitList.hh"
#include "IIR_LibraryUnit.hh"

IIRScram_LibraryUnitList::~IIRScram_LibraryUnitList() {}

void 
IIRScram_LibraryUnitList::_publish_vhdl_in_design_library(){
  IIR_LibraryUnit *lib_unit = first();
  while (lib_unit != NULL) {
    ASSERT(lib_unit->_get_declarator() != NULL);
    lib_unit->_publish_vhdl_decl(IIR::_get_library_manager()->set_output_file(lib_unit));
    lib_unit = successor(lib_unit);
  }
  IIR::_get_library_manager()->flush();
}

void 
IIRScram_LibraryUnitList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_LibraryUnit *lib_unit = first();

  while (lib_unit != NULL) {
    lib_unit->_publish_vhdl_decl(_vhdl_out);
    lib_unit = successor(lib_unit);
  }
}

void 
IIRScram_LibraryUnitList::_publish_cc() {
  IIR_LibraryUnit *lib_unit = first();

  while (lib_unit != NULL) {
    lib_unit->_publish_cc();
    lib_unit = successor(lib_unit);
  }
}

void
IIRScram_LibraryUnitList::_publish_cc_elaborate() {
  IIR_LibraryUnit *unit = first();

  while (unit != NULL) {
    unit->_publish_cc_elaborate();
    unit = successor(unit);
  }  
}


