// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_NullStatement.cc,v 1.2 1999/03/09 20:55:41 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_NullStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"
#include "IIR_List.hh"

IIRScram_NullStatement::~IIRScram_NullStatement() {}


void 
IIRScram_NullStatement::_publish_vhdl(ostream &_vhdl_out) {
  if (get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ": ";
  }
  _vhdl_out << "null";
}

void 
IIRScram_NullStatement::_get_list_of_input_signals(set<IIR_Declaration>*) {
  //Nothing to do anything here. Will be moved to Sequential statements shortly
}

void 
IIRScram_NullStatement::_publish_cc() {
  if (get_label() != NULL) {
    get_label()->_publish_cc();
    _cc_out << ": ";
  }
  _cc_out << "; // VHDL 'null'  statement\n";
}

void 
IIRScram_NullStatement::_type_check() {
  // We don't need to do anything...
}

