// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_RightAttribute.cc,v 1.2 1999/03/09 20:56:17 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_RightAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "error_func.hh"
#include "set.hh"
#include "resolution_func.hh"
#include "IIR_AccessTypeDefinition.hh"

IIRScram_RightAttribute::~IIRScram_RightAttribute() {}

void 
IIRScram_RightAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  ASSERT(get_prefix()->_is_resolved() == TRUE);

  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'RIGHT(";

  if (get_suffix() != NULL) {
    get_suffix()->_publish_vhdl(_vhdl_out);
  } else {
    _vhdl_out << "1";
  }
  _vhdl_out << ") ";
}

void 
IIRScram_RightAttribute::_publish_cc() {
  _publish_cc_type_attribute("RIGHT");
}

IIR_TextLiteral *
IIRScram_RightAttribute::_build_attribute_name() {
  char *name = "right";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_RightAttribute::_get_subtype(){
  return _get_subtype_high_low_left_right();
}

IIR_Declaration *
IIRScram_RightAttribute::_get_implicit_declaration( char *decl_name,
						    IIR_TypeDefinition *decl_type ){
  // This code was blatantly stolen from IIR_LeftAttribute - fixes need 
  // to occur there as well.
  IIR_Declaration *retval;

  if( get_suffix() == NULL ){
    IIR_ConstantDeclaration *const_decl = _build_constant_declaration( decl_name, decl_type );
    ASSERT( decl_type->_is_scalar_type() == TRUE );
    const_decl->set_value( ((IIR_ScalarTypeDefinition *)_get_subtype())->get_right() );
    retval = const_decl;
  }
  else{
    IIR_FunctionDeclaration *func_decl = _build_function_declaration( decl_name, decl_type );
    retval = func_decl;
  }

  return retval;
}

void 
IIRScram_RightAttribute::_resolve_suffix_special(){
  _resolve_suffix_local_static_int();
}

IIR_Boolean 
IIRScram_RightAttribute::_is_value_attribute(){
  ASSERT( _is_resolved() == TRUE );
  if( get_prefix()->_is_scalar_type() == TRUE ){
    ASSERT( get_suffix() == NULL );
    return TRUE;
  }
  else{
    ASSERT( get_prefix()->_is_array_type() == TRUE );
    return FALSE;
  }
}

IIR_Boolean 
IIRScram_RightAttribute::_is_function_attribute(){
  if( _is_value_attribute() == TRUE ){
    return FALSE;
  }
  else{
    return TRUE;
  }
}

set<IIR_TypeDefinition> *
IIRScram_RightAttribute::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  return _get_rval_set_high_low_left_right( constraint_function );
}
