// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SLLOperator.cc,v 1.2 1999/03/09 20:56:20 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_SLLOperator.hh"

IIRScram_SLLOperator::~IIRScram_SLLOperator() {}

void 
IIRScram_SLLOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " sll ";
}


void 
IIRScram_SLLOperator::_publish_cc() {
  _cc_out << "savantSLL(";
  get_left_operand()->_publish_cc();
  _cc_out << ", ";
  get_right_operand()->_publish_cc();
  _cc_out << ")";
}


IIR*
IIRScram_SLLOperator::_clone() {
  IIR_SLLOperator *clone = new IIR_SLLOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_SLLOperator::_get_operator_precedence(){
  return IIRScram::SHIFT_OPERATOR;
}
