// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_TypeDeclaration.cc,v 1.5 1999/10/28 03:24:11 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include <strstream.h>
#include "IIRScram_TypeDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_TextLiteral.hh"
#include "symbol_table.hh"

IIRScram_TypeDeclaration::~IIRScram_TypeDeclaration() {}

void 
IIRScram_TypeDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "type ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  if (get_type() != NULL) {
    _vhdl_out << " is ";
    get_type()->_publish_vhdl_type_decl(_vhdl_out);
  }
  _vhdl_out << ";\n";
}

void 
IIRScram_TypeDeclaration::_publish_cc() {
  _get_declarator()->_publish_cc();
}

void 
IIRScram_TypeDeclaration::_publish_cc_headers() {
  _cc_out << "#include \"";
  _publish_cc_type_name();
  _cc_out << ".hh\"\n";
  get_type()->_publish_cc_headers();
}

void
IIRScram_TypeDeclaration::_publish_cc_type_name() {
  get_type()->_publish_cc_type_name();
}

void
IIRScram_TypeDeclaration::_publish_cc_universal_type(){
  get_type()->_publish_cc_universal_type();
}

void 
IIRScram_TypeDeclaration::_publish_cc_type_info(){
   if((get_type()->_is_scalar_type() == TRUE || 
      get_type()->_is_array_type() == TRUE) &&
      get_type()->_is_access_type() == FALSE){
    get_type()->_publish_cc_type_info();
     _cc_out << ";\n";
  }
}
    
void 
IIRScram_TypeDeclaration::_publish_cc_extern_type_info(){
   if((get_type()->_is_scalar_type() == TRUE ||
      get_type()->_is_array_type() == TRUE) && 
      get_type()->_is_access_type() == FALSE){
    get_type()->_publish_cc_extern_type_info();
     _cc_out << ";\n";
  }
}

void 
IIRScram_TypeDeclaration::_publish_cc_decl() {
  char *className;
  strstream classStream;

  PublishedUnit _saved_publishing_unit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(IIRScram::TYPE);

  classStream << "Savant";
  _get_declarator()->_print(classStream);
  classStream <<"Type" << ends;

  className = classStream.str();
  
  if (get_type()->_is_scalar_type() == FALSE || 
      get_type()->_is_access_type() == TRUE){
    _cc_out.set_file(TRUE, className, ".hh");
    get_type()->_publish_cc_decl_hh();
  }
  
  if(get_type()->_has_access_type() == FALSE) {
    if ((get_type()->_is_record_type() == TRUE) || 
	(get_type()->_is_array_type())){
      _cc_out.set_file(TRUE, className, "_event.hh");
      get_type()->_publish_cc_class_event();
      _cc_out.set_file(TRUE, className, "_lastevent.hh");
      get_type()->_publish_cc_class_last_event();
    }
  }
  
  if (get_type()->_is_scalar_type() == FALSE || 
      get_type()->_is_access_type() == TRUE){  
    _cc_out.set_file(TRUE, className, ".cc");
    _cc_out << "#include \"" << className << ".hh\"\n";
    _cc_out << "#include \"standard.hh\"\n"
	    << endl;
    
    _cc_out.set_file(TRUE, className, ".cc");
    _cc_out << "#include \"" << className << ".hh\"\n";
    _cc_out << "#include \"standard.hh\"\n"
	    << endl;
    
    get_type()->_publish_cc_decl_cc();
  }
  
  _set_currently_publishing_unit(_saved_publishing_unit);
}


void 
IIRScram_TypeDeclaration::_publish_cc_range() {
  ASSERT(get_type() != NULL);
  cerr << "IIRScram_TypeDeclaration::_publish_cc_range() called!! " 
       << "Trying to work around\n";
  get_type()->_publish_cc_range();
}

IIR_Boolean 
IIRScram_TypeDeclaration::_is_access_type() { 
  if( get_type() != NULL ){
    return get_type()->_is_access_type(); 
  }
  else{
    return FALSE;
  }
}


IIR_Boolean
IIRScram_TypeDeclaration::_is_kernel_type() {
  if ((IIRScram_TextLiteral::_cmp(_get_declarator(), "integer") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "boolean") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "severity_level") == 0) ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "positive") == 0)       ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "character") == 0)      ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "real") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "time") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "natural") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "bit") == 0)            ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "side") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "width") == 0)          ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "delay_length") == 0)   ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "file_open_kind") == 0) ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "file_open_status") == 0)
      ) {
    return TRUE;
  }
  else {
    return FALSE;
  }
}

void 
IIRScram_TypeDeclaration::_add_decl_into_cgen_symbol_table() {
  get_type()->_add_decl_into_cgen_symbol_table();
}


IIRScram_Declaration::declaration_type
IIRScram_TypeDeclaration::_get_type() {
  return TYPE;
}

set<IIR_Declaration> *
IIRScram_TypeDeclaration::_find_declarations( IIR_Name *to_find ){
  ASSERT( get_type() != NULL );
  return get_type()->_find_declarations( to_find );
}

set<IIR_Declaration> *
IIRScram_TypeDeclaration::_find_declarations( IIR_TextLiteral *to_find ){
  ASSERT( get_type() != NULL );
  return get_type()->_find_declarations( to_find );
}

IIR_TypeDefinition *
IIRScram_TypeDeclaration::_get_subtype(){
  return get_type();
}

IIR_Boolean
IIRScram_TypeDeclaration::_is_incomplete_type_declaration(){
  if( get_type() == NULL ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}

IIR_Boolean
IIRScram_TypeDeclaration::_designates_incomplete_type(){
  if( get_type() != NULL && get_type()->_designates_incomplete_type() == TRUE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}


IIR_Int32 
IIRScram_TypeDeclaration::_get_num_indexes(){
  if( get_type() != NULL ){
    return get_type()->_get_num_indexes();
  }
  else{
    return -1;
  }
}

IIR_Boolean 
IIRScram_TypeDeclaration::_is_scalar_type(){
  if( get_type() != NULL ){
    return get_type()->_is_scalar_type();
  }
  else{
    return FALSE;
  }
}

IIR_Boolean 
IIRScram_TypeDeclaration::_is_array_type(){
  if( get_type() != NULL ){
    return get_type()->_is_array_type();
  }
  else{
    return FALSE;
  }
}

void
IIRScram_TypeDeclaration::_publish_vhdl_range(ostream &_vhdl_out){
  _publish_vhdl(_vhdl_out);
}

void 
IIRScram_TypeDeclaration::_come_into_scope( symbol_table *sym_tab ){
  // We need to see if this is actually a subtype declaration, due to the
  // organization of AIRE.
  if( _is_iir_subtype_declaration() == FALSE ){
    if( get_type() != NULL ){
      // Now we need to figure out the real base type, since sometimes
      // there are anonymous base types built, and sometimes not.
      IIR_TypeDefinition *base_type = get_type()->get_base_type();
      if( base_type == NULL ){
	base_type = get_type();
      }
    
      base_type->_come_into_scope( sym_tab, (IIR_TypeDeclaration *)this );
      
      if( base_type->_is_iir_access_type_definition() == TRUE &&
	  _designates_incomplete_type() == TRUE ){
	sym_tab->get_designates_incomplete_type()->add( (IIR_TypeDeclaration *)this );
      }
    }
    
    if( _is_incomplete_type_declaration() == TRUE ){
      sym_tab->get_incomplete_types()->add( (IIR_TypeDeclaration *)this );
    }
    else{
      sym_tab->incomplete_type_fixup( (IIR_TypeDeclaration *)this );
    }
  }
}

void 
IIRScram_TypeDeclaration::_come_out_of_scope( symbol_table *sym_tab ){
  if( get_type() != NULL ){
    get_type()->_come_out_of_scope( sym_tab );
  }

  if( _designates_incomplete_type() == TRUE ){
    sym_tab->get_designates_incomplete_type()->remove( (IIR_TypeDeclaration *)this );    
  }
}

IIR_Boolean
IIRScram_TypeDeclaration::_can_be_in_same_region( IIR_Declaration *to_check ){
  if(( _is_incomplete_type_declaration() == TRUE && 
       to_check->_is_incomplete_type_declaration() == FALSE ) ||
     ( _is_incomplete_type_declaration() == FALSE && 
       to_check->_is_incomplete_type_declaration() == TRUE )){
    return TRUE;
  }
  else{
    return FALSE;
  }
}


IIR*
IIRScram_TypeDeclaration::_clone() {
  return this;
}
