// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_UseClause.cc,v 1.10 1999/10/28 03:24:12 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_UseClause.hh"
#include "IIR_Name.hh"
#include "symbol_table.hh"
#include "set.hh"
#include "IIR_PackageDeclaration.hh"
#include "error_func.hh"
#include "IIR_Identifier.hh"
#include "IIR_SelectedName.hh"
#include "IIR_SimpleName.hh"
#include "IIR_LibraryDeclaration.hh"

extern bool debug_symbol_table;

IIRScram_UseClause::IIRScram_UseClause(){
  char *tmp_declarator = "use clause declarator";
  set_declarator( IIR_Identifier::get(tmp_declarator, strlen(tmp_declarator)) );
}

IIRScram_UseClause::~IIRScram_UseClause() {}


void 
IIRScram_UseClause::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_selected_name() != NULL);
  ASSERT(get_selected_name()->_is_resolved());

  _vhdl_out << "use ";
  get_selected_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}


void
IIRScram_UseClause::_publish_vhdl_decl(ostream &_vhdl_out) {
  ASSERT(get_selected_name() != NULL);
  ASSERT(get_selected_name()->_is_resolved());

  _publish_vhdl(_vhdl_out);
}

IIR_Declaration*
IIRScram_UseClause::_get_package_declaration() {
  //###This function needs work
  //yet to scan the full selected name
  ASSERT(get_selected_name() != NULL);
  IIR_Name* name = get_selected_name();
  IIR_SelectedName* selected_name = NULL;
  if(name->get_kind() == IIR_SELECTED_NAME) {
    selected_name = (IIR_SelectedName*)name;
    return selected_name->_get_package_declaration();
  }
  return NULL;
}

void
IIRScram_UseClause::_publish_cc_headers() {
  IIR_Declaration* pkg_decl = _get_package_declaration();
  if(pkg_decl != NULL) {
    if(pkg_decl->_is_textio() || pkg_decl->_is_standard()) {
      //The standard libraries are included by default and so
      //no need to include them
      return;
    } else {
      ASSERT(pkg_decl->get_kind() == IIR_PACKAGE_DECLARATION);
      _cc_out << "#include \"";
      ((IIR_PackageDeclaration*)pkg_decl)->_publish_cc_package_name();
      _cc_out << ".hh\"\n";
    }
  }
}

void
IIRScram_UseClause::_publish_cc_package_name(){
  ASSERT(get_selected_name() != NULL);
  ASSERT(get_selected_name()->_is_resolved());
  ASSERT(get_selected_name()->get_kind() == IIR_SELECTED_NAME);

  // IIR *_prefix = get_selected_name()->get_prefix();
  IIR_Declaration* pkg_name = _get_package_declaration();
  if(pkg_name != NULL) {
    switch(pkg_name->get_kind()) {
    case IIR_PACKAGE_DECLARATION:
      ((IIR_PackageDeclaration *) pkg_name)->_publish_cc_package_name();
      break;
    default:
      cerr << "Unexpected prefix for "
	   << "UseClause::get_selected_name()->get_prefix(): "
	   << pkg_name->get_kind_text() << "\n";
    }
  }
}

void
IIRScram_UseClause::_type_check(){
  set<IIR_Declaration> *use_clause_decls = get_selected_name()->_symbol_lookup();

  if( use_clause_decls == NULL ){
    ostrstream err;
    err << "Unable to locate logical library |" << *get_selected_name() << "|.";
    err << " Perhaps this library hasn't been successfully analyzed yet." << ends;
    report_error( this, err );
    return;
  }

  IIR_Name *tmp_name =  get_selected_name();
  ASSERT( tmp_name->get_kind() == IIR_SELECTED_NAME );

  IIR_Declaration *decl = use_clause_decls->get_element();
  while( decl != NULL ){
    tmp_name->_decl_to_decl( decl );
    
    if( debug_symbol_table == true ){
      cerr << "Processing use clause - making |" << *tmp_name << "| visible!" << endl;
    }
    if( decl->_is_iir_package_declaration() == TRUE ){
      _make_interface_visible( _get_symbol_table() );      
    }
    else{
      _get_symbol_table()->make_visible( decl );
    }
    decl =  use_clause_decls->get_next_element();    
  }

  delete use_clause_decls;

  ASSERT( get_selected_name()->_is_resolved() == TRUE );
}

void 
IIRScram_UseClause::_make_interface_visible( symbol_table *sym_tab ){
  ASSERT( get_selected_name()->_is_resolved() == TRUE );
  set<IIR_Declaration> *decls = get_selected_name()->_symbol_lookup();
  if( decls != 0 ){
    ASSERT( decls->num_elements() == 1 );
    IIR_Declaration *decl = decls->get_element();
    if( sym_tab->in_use_list( decl ) == FALSE ){
      sym_tab->add_to_use_list( decl );
      decl->_make_interface_visible( sym_tab );
    }
  }
  delete decls;
}

IIR *
IIRScram_UseClause::_clone() {
  return this;
}
