#ifndef IIRSCRAM_WAVEFORM_ELEMENT_HH
#define IIRSCRAM_WAVEFORM_ELEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_WaveformElement.hh,v 1.2 1999/03/09 20:57:14 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_WaveformElement.hh"
class IIR_DesignatorList;
class IIR_List;
template <class type> class set;
class IIRScram_WaveformElement : public IIRBase_WaveformElement {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  void _publish_cc_bounds();

  // Methods for semantic checking
  void _type_check( set<IIR_TypeDefinition> * );
  set<IIR_TypeDefinition> *_get_rval_set( IIR_Boolean (IIR::*constraint_function)() = 0 );
  IIR *_semantic_transform( set<IIR_TypeDefinition> *context_set );
  IIR *_rval_to_decl( IIR_TypeDefinition * );

  ostream &_print( ostream &os );

  //Methods for elaboration
  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);

  IIR *_clone();

  IIR_Boolean _is_resolved();
  IIR_Boolean _is_null_transaction();
  IIR_Boolean _is_readable();

protected:
  IIRScram_WaveformElement() {}
  virtual ~IIRScram_WaveformElement() = 0;
    
private:
};
#endif
