
#ifndef VHDL_HH
#define VHDL_HH

// Copyright (c) 1993-1999 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: vhdl.hh,v 1.3 1999/07/27 14:09:17 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include <fstream.h>

extern ofstream info_out;    //file used for writing information messages

// include boolean definitions (used if the c++ compiler doesn't have
// the builtin bool data type
#include "savant.hh"

// include template definitions for doubly-linked lists and hash
// tables to be used in various class definitions.

#include "dl_list.hh"

// global flag for parse errors
extern bool parse_error;

// bring in enumerations from aire definition

#include "IRBasicDataTypes.hh"
#include "IRKind.hh"


// bring in concrete class definitions from aire definition

#include "IIR_AbsoluteOperator.hh"
#include "IIR_AccessSubtypeDefinition.hh"
#include "IIR_AccessTypeDefinition.hh"
#include "IIR_ActiveAttribute.hh"
#include "IIR_AdditionOperator.hh"
#include "IIR_Aggregate.hh"
#include "IIR_AliasDeclaration.hh"
#include "IIR_Allocator.hh"
#include "IIR_AndOperator.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_ArraySubtypeDefinition.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_AscendingAttribute.hh"
#include "IIR_AscendingAttribute.hh"
#include "IIR_AssertionStatement.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_AssociationElementOpen.hh"
#include "IIR_AssociationList.hh"
#include "IIR_AttributeDeclaration.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_BaseAttribute.hh"
#include "IIR_BitStringLiteral.hh"
#include "IIR_BlockConfiguration.hh"
#include "IIR_BlockStatement.hh"
#include "IIR_CaseStatement.hh"
#include "IIR_CaseStatementAlternativeByChoices.hh"
#include "IIR_CaseStatementAlternativeByExpression.hh"
#include "IIR_CaseStatementAlternativeByOthers.hh"
#include "IIR_CaseStatementAlternativeList.hh"
#include "IIR_CharacterLiteral.hh"
#include "IIR_Choice.hh"
#include "IIR_ChoiceList.hh"
#include "IIR_Comment.hh"
#include "IIR_CommentList.hh"
#include "IIR_ComponentConfiguration.hh"
#include "IIR_ComponentDeclaration.hh"
#include "IIR_ComponentInstantiationStatement.hh"
#include "IIR_ConcatenationOperator.hh"
#include "IIR_ConcurrentAssertionStatement.hh"
#include "IIR_ConcurrentConditionalSignalAssignment.hh"
#include "IIR_ConcurrentGenerateForStatement.hh"
#include "IIR_ConcurrentGenerateIfStatement.hh"
#include "IIR_ConcurrentProcedureCallStatement.hh"
#include "IIR_ConcurrentSelectedSignalAssignment.hh"
#include "IIR_ConcurrentStatementList.hh"
#include "IIR_ConditionalWaveform.hh"
#include "IIR_ConditionalWaveformList.hh"
#include "IIR_ConfigurationDeclaration.hh"
#include "IIR_ConfigurationItemList.hh"
#include "IIR_ConfigurationSpecification.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_DelayedAttribute.hh"
#include "IIR_DesignFile.hh"
#include "IIR_DesignFileList.hh"
#include "IIR_DesignatorByAll.hh"
#include "IIR_DesignatorByOthers.hh"
#include "IIR_DesignatorExplicit.hh"
#include "IIR_DesignatorList.hh"
#include "IIR_DisconnectSpecification.hh"
#include "IIR_DivisionOperator.hh"
#include "IIR_DrivingAttribute.hh"
#include "IIR_DrivingValueAttribute.hh"
#include "IIR_ElementDeclaration.hh"
#include "IIR_ElementDeclarationList.hh"
#include "IIR_Elsif.hh"
#include "IIR_EntityClassEntry.hh"
#include "IIR_EntityClassEntryList.hh"
#include "IIR_EntityDeclaration.hh"
#include "IIR_EntityNameList.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_EnumerationLiteralList.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "IIR_EnumerationTypeDefinition.hh"
#include "IIR_EqualityOperator.hh"
#include "IIR_EventAttribute.hh"
#include "IIR_ExitStatement.hh"
#include "IIR_ExponentiationOperator.hh"
#include "IIR_FileDeclaration.hh"
#include "IIR_FileInterfaceDeclaration.hh"
#include "IIR_FileTypeDefinition.hh"
#include "IIR_FloatingPointLiteral.hh"
#include "IIR_FloatingPointLiteral32.hh"
#include "IIR_FloatingPointLiteral64.hh"
#include "IIR_FloatingSubtypeDefinition.hh"
#include "IIR_FloatingTypeDefinition.hh"
#include "IIR_ForLoopStatement.hh"
#include "IIR_FunctionCall.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_GenericList.hh"
#include "IIR_GreaterThanOperator.hh"
#include "IIR_GreaterThanOrEqualOperator.hh"
#include "IIR_GroupConstituent.hh"
#include "IIR_GroupDeclaration.hh"
#include "IIR_GroupTemplateDeclaration.hh"
#include "IIR_HighAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_IdentifierList.hh"
#include "IIR_IdentityOperator.hh"
#include "IIR_IfStatement.hh"
#include "IIR_ImageAttribute.hh"
#include "IIR_IndexedName.hh"
#include "IIR_InequalityOperator.hh"
#include "IIR_InstanceNameAttribute.hh"
#include "IIR_IntegerLiteral.hh"
#include "IIR_IntegerLiteral32.hh"
#include "IIR_IntegerLiteral64.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_IntegerTypeDefinition.hh"
#include "IIR_InterfaceList.hh"
#include "IIR_Label.hh"
#include "IIR_LastActiveAttribute.hh"
#include "IIR_LastEventAttribute.hh"
#include "IIR_LastValueAttribute.hh"
#include "IIR_LeftAttribute.hh"
#include "IIR_LeftOfAttribute.hh"
#include "IIR_LengthAttribute.hh"
#include "IIR_LessThanOperator.hh"
#include "IIR_LessThanOrEqualOperator.hh"
#include "IIR_LibraryClause.hh"
#include "IIR_LibraryDeclaration.hh"
#include "IIR_LowAttribute.hh"
#include "IIR_ModulusOperator.hh"
#include "IIR_MultiplicationOperator.hh"
#include "IIR_NameList.hh"
#include "IIR_NandOperator.hh"
#include "IIR_NegationOperator.hh"
#include "IIR_NextStatement.hh"
#include "IIR_NorOperator.hh"
#include "IIR_NotOperator.hh"
#include "IIR_NullStatement.hh"
#include "IIR_OrOperator.hh"
#include "IIR_OthersInitialization.hh"
#include "IIR_PackageBodyDeclaration.hh"
#include "IIR_PackageDeclaration.hh"
#include "IIR_PathNameAttribute.hh"
#include "IIR_PhysicalLiteral.hh"
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "IIR_PhysicalTypeDefinition.hh"
#include "IIR_PhysicalUnit.hh"
#include "IIR_PortList.hh"
#include "IIR_PosAttribute.hh"
#include "IIR_PredAttribute.hh"
#include "IIR_ProcedureCallStatement.hh"
#include "IIR_ProcedureDeclaration.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_QualifiedExpression.hh"
#include "IIR_QuietAttribute.hh"
#include "IIR_ROLOperator.hh"
#include "IIR_ROROperator.hh"
#include "IIR_RangeAttribute.hh"
#include "IIR_RangeTypeDefinition.hh"
#include "IIR_RecordTypeDefinition.hh"
#include "IIR_RemainderOperator.hh"
#include "IIR_ReportStatement.hh"
#include "IIR_ReturnStatement.hh"
#include "IIR_ReverseRangeAttribute.hh"
#include "IIR_RightAttribute.hh"
#include "IIR_RightOfAttribute.hh"
#include "IIR_SLAOperator.hh"
#include "IIR_SLLOperator.hh"
#include "IIR_SRAOperator.hh"
#include "IIR_SRLOperator.hh"
#include "IIR_SelectedName.hh"
#include "IIR_SelectedNameByAll.hh"
#include "IIR_SelectedWaveform.hh"
#include "IIR_SelectedWaveformList.hh"
#include "IIR_SensitizedProcessStatement.hh"
#include "IIR_SequentialStatementList.hh"
#include "IIR_SharedVariableDeclaration.hh"
#include "IIR_SignalAssignmentStatement.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_Signature.hh"
#include "IIR_SimpleName.hh"
#include "IIR_SimpleNameAttribute.hh"
#include "IIR_SliceName.hh"
#include "IIR_StableAttribute.hh"
#include "IIR_StringLiteral.hh"
#include "IIR_SubtractionOperator.hh"
#include "IIR_SubtypeDeclaration.hh"
#include "IIR_SuccAttribute.hh"
#include "IIR_TransactionAttribute.hh"
#include "IIR_TypeConversion.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_UnitList.hh"
#include "IIR_UseClause.hh"
#include "IIR_UserAttribute.hh"
#include "IIR_ValAttribute.hh"
#include "IIR_ValueAttribute.hh"
#include "IIR_VariableAssignmentStatement.hh"
#include "IIR_VariableDeclaration.hh"
#include "IIR_VariableInterfaceDeclaration.hh"
#include "IIR_WaitStatement.hh"
#include "IIR_WaveformElement.hh"
#include "IIR_WaveformList.hh"
#include "IIR_WhileLoopStatement.hh"
#include "IIR_XnorOperator.hh"
#include "IIR_XorOperator.hh"
#include "IIRScram_IncompleteTypeDefinition.hh"
#endif
