#ifndef SSTRING_HH
#define SSTRING_HH
//---------------------------------------------------------------------------
// Copyright (c) 1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: SString.hh,v 1.6 1999/03/09 22:52:10 dmartin Exp $
//
//---------------------------------------------------------------------------
#include "StringBase.hh"

template <int l, ArrayDirn_t d, int r>
class _savant_string : public StringBase {
  friend ostream& operator<<(ostream&, const _savant_string<l, d, r>&);

public:
 
  _savant_string() : StringBase(l, d, r) {
    val = NULL;
  }

  ~_savant_string() {
    delete [] val;
  }

  _savant_string(const char* );

  _savant_string(const _savant_string&);

  _savant_string& operator=(const char* );

  _savant_string& operator=(_savant_string&);

  bool operator==(char*) const;

  bool operator==(_savant_string&) const;

  bool operator!=(const VHDLData&) const;

  int getSize() const { return sizeof(*this); }
  void print(ostream& ) const;

};

#include "SString.cc"
#endif
