//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef SOURCEINFO_HH
#define SOURCEINFO_HH

#include "Types.hh"
#include "ArrayType.hh"

#include "SourceBase.hh"

extern ResolutionFnPtr *savantResolutionFn;
extern TypeConversionFnPtr *savantTypeConversionFn;
class VHDLKernelBase;

extern const int CHILD_NOT_ADDED;

class SourceInfo : public SourceBase {
public:
  SourceInfo();
  ~SourceInfo();

  SourceInfo& operator = (const SourceInfo&);

  SourceKind get_kind(void) const { return SOURCE_INFO; };

private:
  // Number of children of this node.
  int numChildren;

  // Children of this node.
  SourceBase **child;

  // The following tables are used for fast access of the drivers of this
  // signal.
  // The id of a driver is the id of the process which contains the
  // driver.
  // The "internalTable" contains the list of all the ids of the drivers
  // in this tree.  The index of this table is used to access the drivers
  // in the tree without actually traversing the tree using the
  // "childTable".  This speeds up access of the drivers.
  // The method buildTable() is used to create these tables.
  int *internalTable;
  SourceData **childTable;
  unsigned int tablesize;
  VHDLType* retval;
public:
  // Up and down type conversion function pointerss.
  TypeConversionFnId_t upConvertFnId;
  TypeConversionFnId_t downConvertFnId;

  // Resolution function pointer.
  ResolutionFnId_t resolveFnId;

  // Methods to deal with up and down type conversion functions and
  // resolution functions.
  void setUpTypeConversionFnId(TypeConversionFnId_t);
  void setDownTypeConversionFnId(TypeConversionFnId_t);
  void setResolutionFnId(ResolutionFnId_t);

  TypeConversionFnId_t getUpTypeConversionFnId(void) { return upConvertFnId; };
  TypeConversionFnId_t getDownTypeConversionFnId(void){ 
    return downConvertFnId;
  };
  ResolutionFnId_t getResolutionFnId(void){ return resolveFnId; };

  // Methods to act on the number of children of this node.
  int getNumChildren() const;
  void setNumChildren(int);

  int getNumActiveChildren() const;

  bool _is_child_present(SourceId_t);

  bool _is_driver_connected();
  
  // Methods to act on the child(ren) of this node.  
  // addChild(...) takes a drivers, sets it as the next child and returns
  // the number of children for this node.
  int addChild(SourceBase *);
  int addChild(VHDLType *, SourceId_t);
  SourceBase *getChild(const int) const;
  SourceBase& operator[](const int);
  SourceData *getDriver(const SourceId_t) const;

  SourceData *getDriveratIndex(int) const;
  
  // Method that resolves all the drivers of this driver recursively.
  // This method will call the resolve of all the children and resolve
  // itself.
  VHDLType* resolve(VHDLKernelBase*, SigType typ = EXPLICIT);
  
  void copyTable(const SourceBase*);
  void addToTable(SourceData*);
  int getTableSize(void) const { return int(tablesize); };
  int* getInternalTable() const { return internalTable; };
  
  void print(ostream&) const;
};

#endif
