#ifndef StringBase_HH
#define StringBase_HH
//---------------------------------------------------------------------------
// Copyright (c) 1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//// $Id: StringBase.hh,v 1.6 1999/03/09 22:52:16 dmartin Exp $
//---------------------------------------------------------------------------

#include "VHDLData.hh"
#include "ArrayInfo.hh"
#include "STDTypes.hh"

// class so that all strings can be handled similarly.
class StringBase : public VHDLData {
public:
  ArrayInfo bounds;
  char *val;
  
  StringBase(int l, ArrayDirn_t d, int r) : bounds(l, d, r) {};
  StringBase(StringBase& sb) : bounds(sb.bounds) {};
  ~StringBase() {};

  char& operator[](const int pos);

  virtual int getSize() const { return sizeof(*this); }
  
  virtual VHDLData::UniversalType get_universal_kind() const{
    return STRING_BASE;
  }
  int length() const { return bounds.length(); }

  virtual  void print(ostream& os) const { os << "StringBase(" << bounds << ")"; }
  virtual bool operator !=(const  VHDLData & ) const; 
};

//StringBase& savantConcatenation(StringBase&, StringBase&);
// StringBase& savantConcatenation(StringBase&, StringBase.cc&);
// StringBase& savantConcatenation(StringBase.cc&, StringBase&);
// StringBase& savantConcatenation(StringBase.cc&, StringBase.cc&);

#endif
