#include "Types.hh"

ostream&
operator<<(ostream& os, const SigType& st) {
  switch (st) {
  case EXPLICIT:
    os << "EXPLICIT";
    break;
  case G_REGISTER:
    os << "G_REGISTER";
    break;
  case G_BUS:
    os << "G_BUS";
    break;
  case I_GUARD:
    os << "I_GUARD";
    break;
  case I_STABLE:
    os << "I_STABLE";
    break;
  case I_QUIET:
    os << "I_QUIET";
    break;
  case I_TRANSACTION:
    os << "I_TRANSACTION";
    break;
  default:
    os << "(invalid SigType)";
    break;
  }
  return os;
}


ostream&
operator<<(ostream& os, const PortType& pt) {
  switch (pt) {
  case IN:
    os << "IN";
    break;
  case OUT:
    os << "OUT";
    break;
  case INOUT:
    os << "INOUT";
    break;
  case BUFFER:
    os << "BUFFER";
    break;
  case LINKAGE:
    os << "LINKAGE";
    break;
  default:
    os << "(invalid PortType)";
    break;
  }
  return os;
}


ostream&
operator<<(ostream& os, const VarType& vt) {
  switch (vt) {
  case NORMAL:
    os << "NORMAL";
    break;
  case ACCESS:
    os << "ACCESS";
    break;
  default:
    os << "(invalid VarType)";
    break;
  }
  return os;
}

ostream&
operator << (ostream &os, const AttribType &at) {
  switch(at) {
  case EVENT:
    os << "EVENT";
    break;
  case ACTIVE:
    os << "ACTIVE";
    break;
  case LAST_EVENT:
    os << "LAST_EVENT";
    break;
  case LAST_ACTIVE:
    os << "LAST_ACTIVE";
    break;
  case LAST_VALUE:
    os << "LAST_VALUE";
    break;
  case DRIVING:
    os << "DRIVING";
    break;
  case DRIVING_VALUE:
    os << "DRIVING_VALUE";
    break;
  case STABLE:
    os << "STABLE";
    break;
  case QUIET:
    os << "QUIET";
    break;
  case TRANSACTION:
    os << "TRANSACTION";
    break;
  default:
    os << "(invalid attribute type)";
    break;
  }
  return os;
}

ostream& 
operator << (ostream &os, const Attribute &at) {
  switch(at.attrib) {
  case EVENT:
  case ACTIVE:
  case LAST_VALUE:
  case DRIVING:
  case DRIVING_VALUE:
    os << "Driving_Value Attribute";
    break;
  case LAST_ACTIVE:
  case LAST_EVENT:
    os << "Last_Event attribute";;
    break;
  case STABLE:
  case QUIET:
  case TRANSACTION:
    break;
  default:
    os << "(invalid attribute)";
    break;
  }
  return os;
}
    
LONG
str_to_long_long(const char *str) {
  int i = 0;
  long long int retval = 0;

  while(str[i] != '\0') {
    retval += 10 * retval + (str[i++] - '0');
  }

  return retval;
}
