//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef VHDLDATA_HH
#define VHDLDATA_HH

#include <strstream.h>
#include "bool.hh"

class ostream;
class ArrayInfo;
class SavantlineType;

struct VHDLData {
  enum UniversalType {UNIVERSAL_INTEGER, UNIVERSAL_REAL, UNIVERSAL_CHARACTER,
                      UNIVERSAL_BOOLEAN , UNIVERSAL_LONG_LONG_INTEGER, 
		      SEVERITY_LEVEL, FILE_OPEN_KIND, FILE_OPEN_STATUS,
		      ACCESS_VARIABLE, STRING_BASE, CLASS_WIDE, OTHER_TYPE};

  virtual UniversalType get_universal_kind() const = 0;
//     return OTHER_TYPE;
//   };

  VHDLData(){}
  virtual ~VHDLData(){}
  virtual int length() const { return 1; }
  virtual int getSize() const = 0;
  virtual void print(ostream& os) const = 0;
  virtual bool operator!=(const VHDLData&) const = 0;
  virtual void assignSlice(const VHDLData*, const ArrayInfo*, 
			   const ArrayInfo*);
  virtual void assignSlice(const VHDLData*, const ArrayInfo*);
  virtual VHDLData& operator=(const VHDLData&);

  virtual int savantwrite(ostrstream &) const;
  virtual int savantread(char *);
  virtual int savantread(SavantlineType &);
  virtual int savantwrite(SavantlineType &) const;
  
  virtual bool operator > (const VHDLData&) const;
  virtual bool operator >= (const VHDLData&) const;
  virtual bool operator < (const VHDLData&) const;
  virtual bool operator <= (const VHDLData&) const;
  
  virtual VHDLData *clone() const;
};

// These operators are needed in handling attributes. In array attributes,
// .ie. left, right etc., the return value is of ScalarType. This is because
// each dimension can be a different ScalarType. The problem is that when an
// arithmetic operator is called on a ScalarType and it is not able to find
// out the actual scalar type you are talking about, it will call these 
// operators on VHDLData. So we need the operators here.

extern VHDLData* savantUnaryPlus(const VHDLData&);
extern VHDLData* savantUnaryMinus(const VHDLData&);
extern VHDLData* savantAbs(const VHDLData&);
extern VHDLData* savantPlus(const VHDLData&,const VHDLData&);
extern VHDLData* savantMinus(const VHDLData&,const VHDLData&);
extern VHDLData* savantMultiply(const VHDLData&,const VHDLData&);
extern VHDLData* savantDivide(const VHDLData&,const VHDLData&);
extern VHDLData* savantMod(const VHDLData&,const VHDLData&);
extern VHDLData* savantRem(const VHDLData&,const VHDLData&);
extern VHDLData* savantPow(const VHDLData&,const VHDLData&);

extern ostream& operator<<(ostream&, const VHDLData&);
extern ostream& operator<<(ostream&, const VHDLData::UniversalType);

#endif

