#include "EnumerationType.hh"
#include "Vector.hh"
#include "Savantbit_vectorType_event.hh"

Savantbit_vectorType_event::Savantbit_vectorType_event(ObjectBase::ObjectType objType, const TypeInfo& tInfo) : ArrayType_event(objType, tInfo) {
  object = new Vector<EnumerationType> (objType);
  object->setRange(objType, ArrayType::rangeInfo, 1);
}

Savantbit_vectorType_event::Savantbit_vectorType_event(ObjectBase::ObjectType objType, int left1, ArrayDirn_t dirn1, int right1) : ArrayType(objType)  {
  ArrayInfo aInfo[] = {ArrayInfo(left1, dirn1, right1)};
  object = new Vector<EnumerationType> (objType);
  object->setRange(objType, aInfo, 1);
}

Savantbit_vectorType_event::~Savantbit_vectorType_event()  {}

//Constructor for aggregate initialization
Savantbit_vectorType_event::Savantbit_vectorType_event(ObjectBase::ObjectType objType, 
			   int left, ArrayDirn_t dirn, int right,
			   int noofElmntAssns, ...) {
  ArrayInfo aInfo = ArrayInfo(left, dirn, right);
  object = new Vector<EnumerationType>(objType);
  object->setRange(objType, &aInfo, 1);
    
  va_list ap;
  ElementAssociation* elmtptr;
  ElementAssociation* othersAssociation;
  ElementAssociation** elmtAssocArray;
  char* charptr = NULL;
  int i=0;
  int j=0;
    
  charptr = new char[object->numElems];
  elmtAssocArray = (ElementAssociation**) new char[noofElmntAssns *
						  sizeof(ElementAssociation*)];
  for (i=0; i < object->numElems; i++) {
    charptr[i] = 'U';
  }
    
  va_start(ap, noofElmntAssns);
  for(i =0; i < noofElmntAssns; i++) {
    elmtAssocArray[i] = va_arg(ap, ElementAssociation*);
  }
  va_end(ap);
    
  for(i =0; i < noofElmntAssns; i++) {
    elmtptr = elmtAssocArray[i];
    if(elmtptr->choice == Others) {
      othersAssociation = elmtptr;
      break;
    }
    else {
      if(elmtptr->choice.left() == elmtptr->choice.right()) {
	(*this->object)[elmtptr->choice.left()].assignVal(*elmtptr->value);
	charptr[this->object->bounds.storageIndex(elmtptr->choice.left())]
	  = 'I';
      }
      else {
	if(elmtptr->choice.dirn() == to) {
	  for(j=elmtptr->choice.left(); j < elmtptr->choice.right(); j++) {
	    (*this->object)[j].assignVal(*elmtptr->value);
	    charptr[this->object->bounds.storageIndex(j)] = 'I';
	  }
	}
	else {
	  for(j=elmtptr->choice.left(); j > elmtptr->choice.right(); j--) {
	    (*this->object)[j].assignVal(*elmtptr->value);
	    charptr[this->object->bounds.storageIndex(j)] = 'I';
	  }
	}
      }
    }
  }
    
  for(i=0; i < object->numElems; i++) {
    if(charptr[i] == 'U') {
      this->object->get_element(i) = *othersAssociation->value;
    }
  }
    
  for(i =0; i < noofElmntAssns; i++) {
    delete  elmtAssocArray[i]->value;
    delete  elmtAssocArray[i];
  }
  if(elmtAssocArray != NULL) {
    delete [] elmtAssocArray;
  }
  delete charptr;
    
}
