/*
  Avr.h
  Uros Platise, (c) 1997
*/

#ifndef __AVR
#define __AVR

#include "Serial.h"
#include "sdf.h"
#include "PartDB.h"
#include "PSPI.h"

#define TARGET_MISSING 0xff
#define DEVICE_LOCKED  0x1

class TAvr : public PSPI, public TSDF {
private:
  struct SPart {
    char* name;
    unsigned char PartFamily;
  };
  static SPart  Parts [];
  unsigned char VendorCode;
  unsigned char PartFamily;
  unsigned char PartNumber;
  bool deviceLocked;
  TPartDB* Part;
  TSegTable* segFlash, *segEeprom;
  enum TSegmentName { SEG_FLASH=1, SEG_EEPROM };
public:
  TAvr (TDev*, TPartDB* _Part);
  ~TAvr () { }
  void enableAvr ();
  void identify ();
  int  getPart(unsigned char addr);
  int  readEEPROM (unsigned int addr);
  void writeEEPROM (unsigned int addr, unsigned char byte);
  int readFLASH (unsigned int addr);
  void writeFLASH (unsigned int addr, unsigned char byte);
  void chipErase ();

  static const unsigned char highByte = 0x08;
  static const unsigned char lowByte = 0x00;

  /* Standard Downloading Functions (sdf) */
  void upload (TAout* aout, bool verifyOnly=false);
  void download (TAout* aout);
private:
  void checkMemoryRange (unsigned int addr, unsigned int top_addr);
  void waitAfterWrite ();
  TSegmentName parseSegment (TDataQuery* dataP);
};

#endif
