.TH x-automate n "21 Jan 96"
.SH NAME
x-automate \- GUI interface for x10-amh
.SH SYNOPSIS
\fBx-automate\fP GUI interface for x10-amh
.SH DESCRIPTION
\fBx-automate\fP is a GUI interface for Aaron Hightower's x10-amh.
With this program you can attach icons to your various X10 devices and
see them displayed on a toolbar as well as a floorplan of your own. You
can also read, write and edit programs to download to the CP-290
controller.

\fBx-automate\fP initially reads the file \fB.x10rc\fP in your home directory.  
The format of this file is as follows (I've included a sample.set 
in this distribution):
   
Blank lines and those prefixed with '#' are ignored.

First line defines the audio tool:

   Audio: cat "%sound.au" > /dev/audio

  This will play an audio file when pushing the icon for the
device.  Alternately, you can leave this blank for no audio,
or put: speak "%sound" for the 'speak' text-to-speech program.

I've tried this with the cat technique, play from sox, and vplay.
For vplay you need to do this to suppress the stdout messages:

   Audio: vplay "%sound.voc" 2> /dev/null

play from sox is the best of these, as it doesn't send anything to
stdout, and it doesn't care about the file format.

   Audio: play "%sound.wav" 

  For any of these techniques using audio files, you'll need three
files: 1 each for on, off, and dim, with the filename xxxx-on.xxx,
xxxx-off.xxx xxx-dim.xxx. I've included some samples just for
demonstration purposes.

  The next line defines the floorplan files:

   Floors: floor1.xbm,floor2.xbm,floor3.xbm

  I would recommend creating the floorplans with xfig with the -e xbm
option, and then exporting them to a bitmap format file.  Keep in mind
your screen size when creating this file if you want the whole floor
to be visible on the screen.
  
The remaining lines outline the devices in your home.  The format is:

floor,x,y,house,channel,desc,dim,audio-prefix,icon-prefix

    1,200,300,A,1,dining room,n,~,ceiling,
    1,400,500,A,2,porch,d,~,ceiling
    2,300,200,A,3,hall,d,~,ceiling,
    2,100,100,A,4,stereo,d,~,ceiling
    3,600,800,A,5,3rd floor stairs,d,~,ceiling

\fBDefinitions:\fP

    \fBFloor:\fP The floor of your home for the floorplan screens
    \fBx:\fP The x coordinate on the floorplan
    \fBy:\fP The y coordinate on the floorplan
    \fBHouse:\fP The house code assigned to the device. (A-P)
    \fBChannel:\fP The numerical address assigned to the device (1-16)
    \fBDesc:\fP The text description for the toolbar.
    \fBDimmable:\fP T for true, F for false - determines whether a 
dim control will be present.
    \fBAudio-prefix:\fP A ~ means to repeat the text description.  
This is for the 'speak' program I use for text-to-speech conversion.  
Otherwise you can specify an audio file for the assigned audio program 
in the \fBAudio\fP line of the .x10rc file. This will be concencated 
with 'on' or 'off' for the appropriate pushbutton. 
    \fBIcon-prefix:\fP The first part of the icon name.  This will be
concencated with 'on' or 'off' for the appropriate pushbutton. 

  I've include an editing table to simplify the editing of the 
setup files. If you load a new setup file, or insert or delete
rows in the setup editing screen, the 'remote control' display
will be updated with your changes.  There is no error checking
on this data, so if you enter bad info, you'll probably break
the program.

\fBMenu:\fP

  The menu has the following commands:

\fBFile:\fP

  The file menu has \fBNew, Load, Save, and Save As \fPfor two
types of files - the Setup File (same as the .x10rc file),
and the Schedule File (for downloading to the CP-290), You 
should create an x10 directory under your home as this is 
the default location for these files.  The setup files have 
the suffix '.set', the schedule files '.sch'. This menu 
also has a \fBDisplay Floorplan\fP item to view your facility's
layout with the devices. It also has an \fBExit\fP item to exit 
the program.

\fBEdit:\fP

  The edit menu has options to edit the setup and schedule
currently loaded.  These will be displayed in a tabular form
where you can edit each field and save the changes. 

\fBUtility:\fP

  The utility menu has options for :

    \fBQuery CP-290\fP - Show Day/Time for the CP-290
    \fBSet CP-290\fP - Set the CP-290's Day/Time to the CPU Day/Time
    \fBChange Housecode\fP - Set the default housecode for the CP-290 
    \fBCP-290 Self Test\fP - Run the CP-290 self test and report the
results. (I have to admit - I've never gotten good results from this, 
even from the command line)
    \fBList CP-290 Contents\fP - List the schedule in the CP-290's 
memory. This is dumped to the file \fB.x10dump\fP if you want to save 
the data.

\fBPanic:\fP

  This menu implements the \fB'All Units Off'\fP and \fB'All Units On'\fP 
functions for the default house code.

\fBHelp:\fP

  The help menu has an 'About' which gives the GNU copyleft
statement and thanks to those whose previous work contributed
to this effort.  It also has x-automate Help which displays
this text.

\fBIcons:\fP  I've included an number of icons with the package.  These
are 32x32 GIFs, one for the on and off conditions of each 
device.  There is also a duplicate set of 20x20 GIFs which 
occupy less space on the floorplan.  These have an 's' on the
end of the filename.  Unfortunately, since the X10 system does
not let you poll devices for their state, it's up to you to 
know whether the device is already on or off.  If you create 
new GIFs for icons, I'd welcome getting them to include in the 
package, as mine leave a bit to be desired (but they're 
functional).

\fBFloorplans:\fP  When you activate 'Display Floorplan' on the File menu,
you will be presented with a graphical representaion of your
facility with the appropriate device controls located in frames
on the floorplan.  These frames can be moved by clicking and
dragging with the mouse pointer near their perimeter.  This will
update the x,y coordinates in the setup, which can then be saved.
There will be buttons available to display the various floors of
your facility, and the controls will be present on each floor
according to the floor defined in the setup file. If you change
settings in the setup file, the floorplan will not be updated.
You need to close and reopen your floorplan.

\fBSchedules:\fP  The schedule files follow the format outlined in
Aaron Hightower's x10-amh package.  I've include an editing
table screen to simplify the editing of them.  The file format 
is as follows:

        event {
 	    devmap    2
            daymap    1,2,3,4,5,6,7
            housecode a
            mode      today
            minute    39
            hour      23
            function  dim
            dimlevel  5
        }

        event {
            devmap    2
            daymap    1,2,3,4,5,6,7
            housecode a
            mode      today
            minute    0
            hour      5
            function  off
	}
.SH NOTES
That's about it, I hope you find this useful in some way.
Feedback is always welcome.
.SH AUTHOR
Copyright 1996 - Stew Benedict, benedict@netcom.com

.SS Options
.TP
\fBnone\fP
.SH BUGS
Program is dependant on your setup file - you'll probably break
it with a bad setup syntax.  CP-290 interface is prone to getting
confused if you hammer it with rapid commands in succession.

