/* GNU Chess 5.0 - pgn.c - pgn game format code
   Copyright (c) 1999 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/
/*
 *
 */

#include <stdio.h>
#include <string.h>
#include "common.h"
#include "version.h"

void PGNSaveToFile (char *file)
/****************************************************************************
 *
 *  To save a game into PGN format to a file.  If the file does not exist,
 *  it will create it.  If the file exists, the game is appended to the file.
 *
 ****************************************************************************/
{
   FILE *fp;
   char s[100];
   char *p;
   short i;

   fp = fopen (file, "a");		/*  Can we append to it?  */
   if (fp == NULL)
   {
      printf ("Cannot write to file %s\n", file);
      return;
   }

   /* Write the seven tags */
   fprintf (fp, "[Event \"\"]\n");
   fprintf (fp, "[Site \"\"]\n");
   fprintf (fp, "[Date \"\"]\n");
   fprintf (fp, "[Round \"\"]\n");
   fprintf (fp, "[Result \"\"]\n");
   if (computerplays == white) 
     fprintf (fp, "[White \"%s\"]\n",VERSION);
   else
     fprintf (fp, "[White \"%s\"]\n",name);
   if (computerplays == black)
     fprintf (fp, "[Black \"%s\"]\n",VERSION);
   else
     fprintf (fp, "[Black \"%s\"]\n",name);
   fprintf (fp, "\n");

   s[0] = '\0';
   for (i = 0; i <= GameCnt; i += 2)
   {
      sprintf (s, "%s%d. %s %s ", s, i/2+1, Game[i].SANmv, Game[i+1].SANmv);
      if (strlen (s) > 80)
      {
         p = s + 79;
         while (*p-- != ' ');
         *++p = '\0'; 
         fprintf (fp, "%s\n", s);
         strcpy (s, p+1);
      }
   }
   fprintf (fp, "%s", s);
   fprintf (fp, "*");
   fprintf (fp, "\n\n");
   fclose (fp);
}      


void PGNReadFromFile (char *file)
/****************************************************************************
 *
 *  To read a game from a PGN file.
 *
 ****************************************************************************/
{
   FILE *fp;
   char s[100], c, wmv[8], bmv[8];
   int moveno;
   leaf *p;

   fp = fopen (file, "r");
   if (fp == NULL)
   {
      printf ("Cannot open file %s\n", file);
      return;
   }

   /* Skip all the tags */
   do
   {
      if ((c = fgetc (fp)) == '[')
         fgets (s, 100, fp);
   } while (c == '[');
   ungetc (c, fp);

   InitVars ();
   while (!feof (fp))
   {
      c = fgetc(fp);
      if (c == '*') break;
      ungetc (c, fp);
      fscanf (fp, "%d. %s %s ", &moveno, wmv, bmv);
      p = ValidateMove (wmv);
      if (!p)
      {
	 printf ("Illegal move %d. %s\n", moveno, wmv);
	 break;
      }
      MakeMove (white, &p->move);
      strcpy (Game[GameCnt].SANmv, wmv);
      if (*bmv == '*' ) break;
      p = ValidateMove (bmv);
      if (!p)
      {
	 printf ("Illegal move %d. ... %s\n", moveno, bmv);
	 break;
      }
      MakeMove (black, &p->move);
      strcpy (Game[GameCnt].SANmv, bmv);
   }
   printf ("%d\n", GameCnt);
   fclose (fp);
   ShowBoard ();
   TTClear ();
   return;
}
