#include <gtk/gtk.h>

#include "guiinterface.h"

#include "../game.h"

GtkWidget **newgame_dialog_widget;

extern PlayerOptions player_options[2];

void cb_cancel(GtkWidget *w, gpointer data)
{
	gtk_widget_destroy(*newgame_dialog_widget);
	*newgame_dialog_widget = NULL;
}

void cb_newgame(GtkWidget *w, gpointer data)
{
	score_init();
	game_init_play();
	gtk_widget_destroy(*newgame_dialog_widget);
	*newgame_dialog_widget = NULL;
}

void gui_newgame_dialog_create(GtkWidget **window)
{
	static GuiBoolChoice bc = {
		"Confirm new game",
		"Are you sure you want to start a new game\n"
		"and initialize score table to 0:0?",
		{"Yes", "No"},
		{NULL, NULL},
		{GTK_SIGNAL_FUNC(cb_newgame), GTK_SIGNAL_FUNC(cb_cancel), GTK_SIGNAL_FUNC(cb_cancel)},
		{NULL, NULL, NULL}
	};

	newgame_dialog_widget = window;
	*window = gui_bool_choice_dialog_new(&bc);
}
