#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "guiinterface.h"

#include "../ai/aiinterface.h"

#include "../game.h"

extern GlobalOptions global_options;
extern PlayerOptions player_options[2];
extern Square game_winner; /* 0 = none (game in progress), X+1 = winner number */
extern int turn, e_turn;
extern PlayerType current_player;

void player_type_selected(GtkWidget *w, int which);

GuiContainedWidget specific_options_config[2] = {{NULL, NULL}, {NULL, NULL}};

int current_ai_level[2];

struct {
	GtkTooltips *tooltips;
	GtkWidget *starter;
	GtkWidget *clear_board;
	GtkWidget *allow_undo;
	struct {
		GtkWidget *type;
		GtkWidget *name;
		union {
			struct {
				GtkWidget *level;
			} ai;
			struct {
				GtkWidget *none;
			} human;
		} specific_options;
	} player[2];
} data;

GuiOptionMenu option_menu_player0_type = 
{	2,
	{	{"Human", player_type_selected, (gpointer)0},
		{"AI", player_type_selected, (gpointer)0}
	}
};

GuiOptionMenu option_menu_player1_type = 
{	2,
	{	{"Human", player_type_selected, (gpointer)1},
		{"AI", player_type_selected, (gpointer)1}
	}
};

GuiOptionMenu *option_menu_player_type[2] = 
{	&option_menu_player0_type,
	&option_menu_player1_type
};

GuiOptionMenu option_menu_starter =
{	2,
	{	{"Player 1", NULL, NULL},
		{"Player 2", NULL, NULL}
	}
};

GuiOptionMenu option_menu_ailevel =
{	5,
	{	{"(1) Quai Gan Gin", NULL, NULL},
		{"(2) Darth Mol", NULL, NULL},
		{"(3) Obi wan Kanoobi", NULL, NULL},
		{"(4) Annakin Skywalker/Darth Vaider", NULL, NULL},
		{"(5) Luke Skywalker", NULL, NULL}
	}
};

/* Set options according to buttons state
 */
void cb_options_ok(GtkWidget *w, GtkWidget *dialog)
{
	int which;
	PlayerType pt;

	global_options.starter = gui_option_menu_get_selected(data.starter);
	if(!turn)
		e_turn = global_options.starter;
	global_options.clear_board = GTK_TOGGLE_BUTTON(data.clear_board)->active;
	global_options.allow_undo = GTK_TOGGLE_BUTTON(data.allow_undo)->active;
	for(which=0; which<2; which++) {
		pt = gui_option_menu_get_selected(data.player[which].type);
		if(e_turn == which) {
			if(player_options[which].pt == PLAYER_AI && pt != PLAYER_AI)
				ai_break();
			current_player = player_options[which].pt;
		}
		player_options[which].pt = pt;
		free(player_options[which].name);
		player_options[which].name = strdup(gtk_entry_get_text(GTK_ENTRY(data.player[which].name)));

		if(player_options[which].pt == PLAYER_AI)
			player_options[which].ai_player.level = gui_option_menu_get_selected(data.player[which].specific_options.ai.level)+1;
		else
			player_options[which].ai_player.level = current_ai_level[which];
	}
	gtk_widget_destroy(dialog);
	gui_score_update(); /* Update player names */
	game_play();
}

GtkWidget *_specific_options_config_new(int which, PlayerType pt)
{
	GtkWidget *frame = NULL, *box[2], *widget;

	switch(pt) {
	case PLAYER_HUMAN:
		return gtk_hbox_new(FALSE, 0);
	/*
		frame = gtk_frame_new("Human config");
		gtk_container_border_width(GTK_CONTAINER(frame), 5);
		gtk_container_add(GTK_CONTAINER(frame), box[0]);

		widget = gtk_label_new("Input: ");
		gtk_box_pack_start(GTK_BOX(box[1]), widget, FALSE, FALSE, 0);

		data.Player[which].p.Control = Build_Option_Menu(ControlOptions, 1, (int)Current_Human_Control[which]);
		gtk_tooltips_set_tip(GTK_TOOLTIPS(data.Tooltips), data.Player[which].p.Control, "What input device will be used", NULL);
		gtk_box_pack_start(GTK_BOX(box[1]), data.Player[which].p.Control, FALSE, FALSE, 0);
		break;*/
	case PLAYER_AI:
		frame = gtk_frame_new("AI config");
		gtk_container_border_width(GTK_CONTAINER(frame), 5);

		box[0] = gtk_vbox_new(FALSE, 0);
		gtk_container_add(GTK_CONTAINER(frame), box[0]);

		box[1] = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(box[0]), box[1], FALSE, FALSE, 0);

		widget = gtk_label_new("AI level: ");
		gtk_box_pack_start(GTK_BOX(box[1]), widget, FALSE, FALSE, 0);

		data.player[which].specific_options.ai.level = gui_option_menu_new(&option_menu_ailevel, current_ai_level[which]-1);
		gtk_tooltips_set_tip(GTK_TOOLTIPS(data.tooltips), data.player[which].specific_options.ai.level, "AI Level", NULL);
		gtk_box_pack_start(GTK_BOX(box[1]), data.player[which].specific_options.ai.level, FALSE, FALSE, 0);
		break;
	}

	return frame;
}

void player_type_selected(GtkWidget *w, int which)
{
	static PlayerType oldpt[2] = {PLAYER_HUMAN, PLAYER_AI};
	PlayerType pt;

	if(GTK_WIDGET_MAPPED(w) && ((pt = gui_option_menu_get_selected(data.player[which].type)) != oldpt[which])) {
		if(oldpt[which] == PLAYER_AI)
			current_ai_level[which] = gui_option_menu_get_selected(data.player[which].specific_options.ai.level)+1;
		oldpt[which] = pt;
		gtk_widget_destroy(specific_options_config[which].widget);
		specific_options_config[which].widget = _specific_options_config_new(which, pt);
		gtk_box_pack_start(GTK_BOX(specific_options_config[which].container), specific_options_config[which].widget, FALSE, FALSE, 0);
		gtk_widget_show_all(specific_options_config[which].container);
	}
}

GtkWidget *_player_config_new(int which)
{
	GtkWidget *frame, *widget, *box[2];
	static char str[64];

	current_ai_level[which] = player_options[which].ai_player.level;

	sprintf(str, "Player %d preferences", which+1);
	frame = gtk_frame_new(str);
	gtk_container_border_width(GTK_CONTAINER(frame), 5);

	box[0] = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), box[0]);

	box[1] = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box[0]), box[1], FALSE, FALSE, 3);

	sprintf(str, "Player %d's type: ", which+1);
	widget = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(box[1]), widget, FALSE, FALSE, 0);
	data.player[which].type = gui_option_menu_new(option_menu_player_type[which], player_options[which].pt);
	sprintf(str, "Select the controller of player %d", which+1);
	gtk_tooltips_set_tip(GTK_TOOLTIPS(data.tooltips), GTK_WIDGET(data.player[which].type), str, NULL);
	gtk_box_pack_start(GTK_BOX(box[1]), data.player[which].type, FALSE, FALSE, 0);

	box[1] = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box[0]), box[1], FALSE, FALSE, 3);
	widget = gtk_label_new("Player name: ");
	gtk_box_pack_start(GTK_BOX(box[1]), widget, FALSE, FALSE, 3);
	data.player[which].name = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(data.player[which].name), player_options[which].name);
	gtk_box_pack_start(GTK_BOX(box[1]), data.player[which].name, FALSE, FALSE, 3);

	specific_options_config[which].container = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box[0]), specific_options_config[which].container, FALSE, FALSE, 0);
	specific_options_config[which].widget = _specific_options_config_new(which, player_options[which].pt);
	gtk_box_pack_start(GTK_BOX(specific_options_config[which].container), specific_options_config[which].widget, FALSE, FALSE, 0);

	return frame;
}

GtkWidget *_general_config_new(void)
{
	GtkWidget *frame, *widget, *box[2];

	frame = gtk_frame_new("General");
	gtk_container_border_width(GTK_CONTAINER(frame), 5);

	box[0] = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), box[0]);

	box[1] = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box[0]), box[1], FALSE, FALSE, 0);

	widget = gtk_label_new("First turn by: ");
	gtk_box_pack_start(GTK_BOX(box[1]), widget, FALSE, FALSE, 0);

	data.starter = gui_option_menu_new(&option_menu_starter, global_options.starter);
	gtk_tooltips_set_tip(GTK_TOOLTIPS(data.tooltips), data.starter, "This determines who goes first", NULL);
	gtk_box_pack_start(GTK_BOX(box[1]), data.starter, FALSE, FALSE, 0);

	data.clear_board = gtk_check_button_new_with_label("Clear board");
	gtk_tooltips_set_tip(GTK_TOOLTIPS(data.tooltips), data.clear_board, "Clear board after game is over", NULL);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(data.clear_board), global_options.clear_board);
	gtk_box_pack_start(GTK_BOX(box[0]), data.clear_board, FALSE, FALSE, 0);

	data.allow_undo = gtk_check_button_new_with_label("Allow undo's");
	gtk_tooltips_set_tip(GTK_TOOLTIPS(data.tooltips), data.allow_undo, "Allow undo/redo operations", NULL);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(data.allow_undo), global_options.allow_undo);
	gtk_box_pack_start(GTK_BOX(box[0]), data.allow_undo, FALSE, FALSE, 0);

	return frame;
}

GtkWidget *_button_pad_new(GtkWidget *dialog)
{
	GtkWidget *box, *widget;

	box = gtk_hbox_new(FALSE, 5);

	widget = gtk_button_new_with_label(" Ok ");
	gtk_signal_connect(GTK_OBJECT(widget), "clicked", GTK_SIGNAL_FUNC(cb_options_ok), dialog);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 10);

	widget = gtk_button_new_with_label(" Cancel ");
	gtk_signal_connect_object(GTK_OBJECT(widget), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 10);

	return box;
}

void gui_options_dialog_create(GtkWidget **options_dialog)
{
	GtkWidget *box[2], *widget;

	*options_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(*options_dialog), "destroy", GTK_SIGNAL_FUNC(cb_dialog_destroy), options_dialog);
	gtk_window_set_title(GTK_WINDOW(*options_dialog), "Game options");
	gtk_container_border_width(GTK_CONTAINER(*options_dialog), 10);

	data.tooltips = gtk_tooltips_new();

	box[0] = gtk_vbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(*options_dialog), box[0]);

	box[1] = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box[0]), box[1], FALSE, FALSE, 0);

	widget = _general_config_new();
	gtk_box_pack_start(GTK_BOX(box[1]), widget, FALSE, FALSE, 0);

	widget = _player_config_new(0); /* Build player 1's config frame */
	gtk_box_pack_start(GTK_BOX(box[1]), widget, FALSE, FALSE, 0);

	widget = _player_config_new(1); /* Build player 2's config frame */
	gtk_box_pack_start(GTK_BOX(box[1]), widget, FALSE, FALSE, 0);

	widget = _button_pad_new(*options_dialog);
	gtk_box_pack_end(GTK_BOX(box[0]), widget, TRUE, FALSE, 0);

	gtk_widget_show_all(*options_dialog);
}
