#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <errno.h>

#include "history.h"
#include "game.h"
#include "gui/guiinterface.h"
#include "ai/aiinterface.h"

#define _MAGIC "GWogo Saved Game\n\1"
#define _MAGIC_LEN 19

Coordinate history[BOARD_XSIZE * BOARD_YSIZE];

extern int turn, e_turn;
int _redoable = 0;
extern Square board[BOARD_XSIZE][BOARD_YSIZE];
extern PlayerOptions player_options[2];

void history_load(char *name)
{
	int f = open(name, O_RDONLY), i;
	char magic[_MAGIC_LEN];

	if (f == -1) {
		perror("file opening");
		gui_dialog_new("Error!", "Couldn't open file for loading.\n");
		return;
	}
	read(f, magic, sizeof(magic));
	if(memcmp(magic, _MAGIC, sizeof(magic))) {
		gui_dialog_new("Error!", "Inappropriate savegame.");
		return;
	}
	read(f, &e_turn, sizeof(e_turn));
	read(f, &_redoable, sizeof(_redoable));
	read(f, &i, sizeof(i));
	read(f, history, sizeof(Coordinate)*(i+_redoable));
	score_init();
	game_init();
	for(; _redoable; )
		history_move_redo();
	_redoable = i;
	close(f);
}

void history_save(char *name)
{
	int f = creat(name, 0666), starter;

	if (f == -1) {
		perror("file creation");
		gui_dialog_new("Error!", "Couldn't create file for saving.\n");
		return;
	}
	starter = (turn&1) ^ e_turn;
	write(f, _MAGIC, _MAGIC_LEN);
	write(f, &starter, sizeof(starter));
	write(f, &turn, sizeof(turn));
	write(f, &_redoable, sizeof(_redoable));
	write(f, history, sizeof(Coordinate)*(turn+_redoable));
	close(f);
}

void history_move_register(Coordinate *move)
{
	coordinate_copy(&history[turn], move);
	_redoable = 0;
}

Coordinate *history_move_get(int index)
{
	if(index < 0)
		return NULL;
	else
		return &history[index];
}

void history_move_undo(void)
{
	int count = 1;
	Coordinate *last_move;

	if(turn) {
		ai_break();
		do {
			turn--;
			e_turn ^= 1;
			ARRAY_COOR(board, history[turn]) = NONE;
			gui_board_square_delete(&history[turn]);
			_redoable++;
		} while(player_options[e_turn].pt == PLAYER_AI && count-- && turn);
		if(turn) {
			last_move = history_move_get(turn - 1);
			gui_board_square_set_last(last_move, ARRAY_COOR(board, *last_move)-1);
		}
		game_play();
	}
}

void history_move_redo(void)
{
	if(_redoable) {
		ai_break();
		_redoable--;
		game_move_make(&history[turn]);
	}
}
