/*C* -*-c++-*-
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "alphaTable.h"
#include "../util/debug.h"

//--------------------------------------------------------------------------------------------------------------------------------

// FIXME erm, global variables /probably/ shouldn't be 64k in size - it has a bloating effect on executables...

unsigned char alphaTable[256][256];

void initAlphaTable()
{
 static bool alreadyInit = false;
 if(alreadyInit) return;

 VPRINTF("<vgacntxt> initialising alpha table\n");
 for(int a = 0; a < 256; a++) for(int b = 0; b < 256; b++)
  alphaTable[a][b] = (a * b) / 255;

 alreadyInit = true;
}

//--------------------------------------------------------------------------------------------------------------------------------
