/*C* $Id: ghost.cc,v 1.4 1997/08/14 22:10:43 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Data.h"
#include "Ghost.h"
#include "globals.h"
#include "../gl/Aset.h"
#include "../gl/Console.h"
#include "../gl/mode.h"
#include "../gl/Sprite.h"
#include "../gl/VgaBlur.h"
#include "../util/util.h"
#include <stdio.h>
#include <stdlib.h>

template class Collection<Ghost>;

int Ghost::flash = 0;

Ghost::Ghost(int _x, int _y, int _defaultSprite)
 : Actor()
{
 start.set(_x, _y);
 setPos(start);
 state = Alive;

 defaultSprite = _defaultSprite;
}

Ghost::~Ghost()
{
}

void Ghost::draw()
{
 Sprite* sprite;
 switch(state)
  {
  case Alive:
   sprite = asetGhost->at(defaultSprite)->at(0);
   break;
  case Scared:
   sprite = asetGhost->at(8)->at(flash?0:1);
   break;
  case Dead:
   sprite = asetGhost->at(6)->at(0);
   break;
  default:
   exit(-1);
  }
 Point p = screenPos();
 if(p.x <= -sprW) p.x += vgaW; else if((p.x + sprW) >= vgaW) p.x -= vgaW;
 if(p.y <= -sprH) p.y += vgaH; else if((p.y + sprH) >= vgaH) p.y -= vgaH;
 if(p.x < 0 || p.y < 0)
  {
   if(p.x < 0) screen->blur2(sprite->draw(screen, Point(p.x + vgaW, p.y)));
   if(p.y < 0) screen->blur2(sprite->draw(screen, Point(p.x, p.y + vgaH)));
  }
 screen->blur2(sprite->draw(screen, Point(p.x, p.y)));
}
  
void Ghost::restart()
{
 setPos(start);
 state = Alive;
}

void Ghost::pellet()
{
 if(state != Dead)
  {
   state = Scared;
   turnBack();
  }
}
