/*C* $Id: level.cc,v 1.7 1997/09/26 17:52:32 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Background.h"
#include "Data.h"
#include "level.h"
#include "../gl/Console.h"
#include "../gl/Sprite.h"
#include "../gl/Sset.h"
#include "../gl/VgaBlur.h"
#include "../util/debug.h"
#include "../util/File.h"
#include "../util/util.h"
#include <assert.h>

//-----------------------------------------------------------------------------
Level::Level()
{
}

//-----------------------------------------------------------------------------
Level& Level::operator=(const Level& level)
{
 assert(&level != NULL);
 memcpy(data, level.data, sizeof(level.data));
 dots = level.dots;
 return *this;
}

//-----------------------------------------------------------------------------
bool Level::load(File* f)
/*
 * Loads a level from a FILE*
 */
{
 assert(f != NULL);
 bool ret;
 ret = f->read(&data[0][0], sizeof(data))? true : false;
 // set up the dot count & stuff
 dots = 0;
 for(int x=0; x<lvlW; x++) for(int y=0; y<lvlH; y++)
  {
   // the next line stops data from ever being invalid once loaded
   //data[x][y] %= BLOCKS;
   if(data[x][y] == 1) dots++;
  }
 return ret;
}

//-----------------------------------------------------------------------------
bool Level::load(const char* filename)
/*
 * Loads a level from the file named
 */
{
 assert(filename != NULL);
 File* f = new File(filename, "r");
 if(!*f) goto error;
 if(!load(f)) goto error;
 delete f;
 return true;
error:
 delete f;
 nonFatal("Error loading level from %s.\n", filename);
 return false;
}

//-----------------------------------------------------------------------------
void Level::getGhosts(Collection<Ghost>* ghosts)
/*
 * This scans the level and creates a Ghost object for each ghost it finds.
 */
{
 assert(ghosts != NULL);
 for(int x=0; x<lvlW; x++) for(int y=0; y<lvlH; y++)
  {
   if(data[x][y] >= 25 && data[x][y] <= 30)
    {
     ghosts->add(new Ghost(x, y, data[x][y] - 25));
     clear(Pos(x, y));
    }
  }
}

//-----------------------------------------------------------------------------
bool Level::save(FILE *fp)
{
 assert(fp != NULL);
 return fwrite(&data[0][0], sizeof(data), 1, fp) ? true : false;
}

//-----------------------------------------------------------------------------
void Level::draw(Pos p)
{
 assert(p.x >= 0); assert(p.y >= 0); assert(p.x < lvlW); assert(p.y < lvlH);
 // redraw the background
 VgaContext::copyBox(bk, Rect(p.x*sprW, p.y*sprH, sprW, sprH) + stagePos, screen);
 // draw the level square
 ssetBlocks->at(data[p.x][p.y])->draw(screen, Point(p.x*sprW, p.y*sprH) + stagePos);
}

//-----------------------------------------------------------------------------
void Level::drawKBo(Pos p)
{
 assert(p.x >= 0); assert(p.y >= 0); assert(p.x < lvlW); assert(p.y < lvlH);
 VgaContext::copyBox(bk, Rect(p.x*sprW, p.y*sprH, sprW, sprH) + stagePos, screen);
 screen->keepAndBlur1(ssetBlocks->at(data[p.x][p.y])->draw(screen, Point(p.x*sprW, p.y*sprH) + stagePos));
}
void Level::drawK(Pos p)
{
 assert(p.x >= 0); assert(p.y >= 0); assert(p.x < lvlW); assert(p.y < lvlH);
 VgaContext::copyBox(bk, Rect(p.x*sprW, p.y*sprH, sprW, sprH) + stagePos, screen);
 screen->keep(ssetBlocks->at(data[p.x][p.y])->draw(screen, Point(p.x*sprW, p.y*sprH) + stagePos));
}
void Level::drawKU(Pos p)
{
 assert(p.x >= 0); assert(p.y >= 0); assert(p.x < lvlW); assert(p.y < lvlH);
 VgaContext::copyBox(bk, Rect(p.x*sprW, p.y*sprH, sprW, sprH) + stagePos, screen);
 screen->keepAndUpdate(ssetBlocks->at(data[p.x][p.y])->draw(screen, Point(p.x*sprW, p.y*sprH) + stagePos));
}

//-----------------------------------------------------------------------------
void Level::draw()
/*
 * Draws the whole level.
 */
{
 for(int x=0; x<lvlW; x++) for(int y=0; y<lvlH; y++)
  draw(Pos(x,y));
}

//-----------------------------------------------------------------------------
void Level::setSquare(Pos p, int type)
     /*
      * Sets a square. Also takes care of the dot count
      */
{
 assert(p.x >= 0); assert(p.y >= 0); assert(p.x < lvlW); assert(p.y < lvlH);
 //assert(type >= 0); assert(type < BLOCKS);
 if(data[p.x][p.y] == 1) dots--;
 data[p.x][p.y] = type;
 if(data[p.x][p.y] == 1) dots++;
}
void Level::setSquareAndDrawK(Pos p, int type)
{
 setSquare(p, type);
 drawK(p);
}
void Level::setSquareAndDrawKU(Pos p, int type)
{
 setSquare(p, type);
 drawKU(p);
}

//-----------------------------------------------------------------------------
void Level::clear(Pos p)
{
 assert(p.x >= 0); assert(p.y >= 0); assert(p.x < stageSize.x); assert(p.y < stageSize.y);
 if(data[p.x][p.y] == 1) dots--;
 data[p.x][p.y] = 0;
}

void Level::clear()
{
 for(int x=0; x<lvlW; x++) for(int y=0; y<lvlH; y++) clear(Pos(x, y));
}

//-----------------------------------------------------------------------------
void Level::clearAndDrawKBo(Pos p)
{
 clear(p);
 drawKBo(p);
}

//-----------------------------------------------------------------------------
bool Level::checkLevel()
     /*
      * Checks that the level is valid - right number of special squares etc...
      */
{
 /*
 int nPlayer = 0, nBase = 0, nScore0 = 0, nScore2 = 0;
 for(int x=0; x<lvlW; x++) for(int y=0; y<lvlH; y++)
  {
   if(BLOCK_IS_START(data[x][y])) nPlayer++;
   if(BLOCK_IS_BASE(data[x][y])) nBase++;
   if(BLOCK_IS_SCORE_0(data[x][y])) nScore0++;
   if(BLOCK_IS_SCORE_2(data[x][y])) nScore2++;
  }
 if(nPlayer != 1) return false;
 if(nBase != 1) return false;
 if(nScore0 != 1) return false;
 if(nScore2 != 1) return false;
 */
 return true;
}

//-----------------------------------------------------------------------------
Pos Level::find(int block)
{
 //assert(block >= 0); assert(block < BLOCKS);
 for(int x=0; x<lvlW; x++) for(int y=0; y<lvlH; y++)
  if(data[x][y] == block) return Pos(x, y);
 return Pos(-1, -1);
}
