/*C* $Id$
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef util_Obstack_h
#define util_Obstack_h

#include "xmalloc.h"
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif
#include <obstack.h>
#ifdef __cplusplus
}
#endif

#define obstack_chunk_alloc xmalloc
#define obstack_chunk_free free

#ifdef __cplusplus

extern "C" void obstack_free_hack(obstack*, void*);
extern "C" void obstack_init_hack(obstack*);

class Obstack
{
public:
 inline Obstack() { init(); }
 inline ~Obstack() { free(NULL); }
 inline void init() { obstack_init_hack(&ob); }
 void *alloc(int size) { return obstack_alloc(&ob, size); }
 void *copy(void* addr, int size) { return obstack_copy(&ob, addr, size); }
 void *copy0(void* addr, int size) { return obstack_copy0(&ob, addr, size); }
 void free(void* object) { obstack_free_hack(&ob, object); }
 void blank(int size) { obstack_blank(&ob, size); }
 void grow(void* addr, int size) { obstack_grow(&ob, addr, size); }
 void grow0(void* addr, int size) { obstack_grow0(&ob, addr, size); }
 void grow(char data) { obstack_1grow(&ob, data); }
 void grow(const char* addr) { obstack_grow(&ob, addr, strlen(addr)); }
 void *finish() { return obstack_finish(&ob); }
 int objectSize() { return obstack_object_size(&ob); }
 void blankFast(int size) { obstack_blank_fast(&ob, size); }
 void growFast(char data) { obstack_1grow_fast(&ob, data); }
 int room() { return obstack_room(&ob); }
 int alignmentMask() { return obstack_alignment_mask(&ob); }
 int chunkSize() { return obstack_chunk_size(&ob); }
 void *base() { return obstack_base(&ob); }
 void *nextFree() { return obstack_next_free(&ob); }
private:
 struct obstack ob;
};

#endif

#endif
