/*C* $Id: str.h,v 1.3 1997/09/27 00:08:59 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef util_String_h
#define util_String_h

#include "Object.h"
#include "util.h"
#include <string.h>

class String : public Object
{
private:
 char* s;
public:
 inline String() { s = newString(""); }
 inline String(String& object) : Object(object) { s = newString(object.s); }
 inline String(const char* _s) { s = newString(_s); }
 inline String(int i) { s = newString(i); }
 inline ~String() { delete s; }
 inline int length() { return strlen(s); }
 inline operator const char* () { return s; }
 const char* cs() { return s; }
 String& operator = (String& string);
 String& operator = (const char* object);
 String& operator += (const char* object);
 String& operator += (const char object);
 String operator + (const char* object);
 String operator + (const char object);
 bool endsin(const char* end);
};

#endif
