/*C* $Id: ticker.h,v 1.3 1997/08/21 20:39:29 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef ticker_h
#define ticker_h

#include "util.h"

class Ticker
{
public:
 Ticker(unsigned _interval);
 inline void tick() { ticks += interval; }
 inline void tickAndCatchUp() { if(getTicks() > (ticks += interval)) ticks = getTicks(); }
 inline bool spare() { return (getTicks() < ticks)? true : false; }
 inline bool past() { return (getTicks() > ticks)? true : false; }
 void yield();
private:
 unsigned interval;
 unsigned long long ticks;
};

#endif
