/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/
/*
 * ViewObject - abstract base class for the documentation viewer
 */

#ifndef viewer_ViewObject_h
#define viewer_ViewObject_h

#include "../util/Object.h"
#include "../gl/VgaBlur.h"
#include "../gl/Font.h"

class ViewObject : public Object
{
protected:
 int width;
 int height;
 int vOffset;
  
public:
 ViewObject(int _width, int _height, int _offset)
  {
   width = _width;
   height = _height;
   vOffset = _offset;
  }
 
 int getVOffset() { return vOffset; }
 int getWidth() { return width; }
 int getHeight() { return height; }
 
 virtual int draw(class Point p, VgaBlur* vc) = 0;
};

class Line : public ViewObject
{
public:
 Line(int _width, int _height, int _offset, Font* _font, /*Font::HAlign*/int _align, int _margin, int _color, char* _text);
 virtual ~Line() { delete text; }
 virtual int draw(class Point p, VgaBlur* vc);

private:
 char* text;
 Font* font;
 /*Font::HAlign*/int align;
 int color;
 int hOffset;
};

class VSpace : public ViewObject
{
public:
 VSpace(int _width, int _height, int _offset) : ViewObject(_width, _height, _offset) {}
 virtual int draw(Point, VgaBlur*) { return height; }
};

#endif


