/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <math.h>
#include "../ballistics.h"
#include "../terrain.h"
#include "../aiexterns.h"
#include "roller.h"

Shellstat_bal wepRollerInit(struct Projectilepos_bal *prjpos, void** guide,
						   Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
														  void** explosioninfo), 
						   void** explosioninfo)
{
	Player_pl *plhit;
    int ix, iy;

	*guide=NULL;
	
    if(balCheckTankIntersect(prjpos->x, prjpos->y, &plhit, &ix, &iy))
    {
		prjpos->x=ix;
		prjpos->y=iy;
		aihExplosionHook(prjpos);
		return initexplosion(prjpos, explosioninfo);
    }
    else
    {
		if(terCheckPos(ter_data, prjpos->x+1, prjpos->y+1) &&
		   !terCheckPos(ter_data, prjpos->x-1, prjpos->y+1))
		{
			prjpos->vx=-1;			
		}
		if(terCheckPos(ter_data, prjpos->x-1, prjpos->y+1) &&
		   !terCheckPos(ter_data, prjpos->x+1, prjpos->y+1))
		{
			prjpos->vx=1;
		}
		prjpos->ox=prjpos->x;
		prjpos->oy=prjpos->y;
		return FLYING;
    }
}

Shellstat_bal wepRollerGuidance(void* info, struct Projectilepos_bal *prjpos, 
							   Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
															  void** explosioninfo), 
							   void **explosioninfo)
{
    int i, ix, iy;
    Player_pl *plhit;

    prjpos->ox=prjpos->x;
    prjpos->oy=prjpos->y;	    
	for(i=0; i<20; i++) 
	{
		if(balCheckTankIntersect(prjpos->x, prjpos->y+5, &plhit, &ix, &iy))
		{
			prjpos->x=ix;
			prjpos->y=iy;
			aihExplosionHook(prjpos);
			return initexplosion(prjpos, explosioninfo);
		}
		if(prjpos->x <= 0 || prjpos->x >= ter_sizex)
		{
			prjpos->x=-1;
			prjpos->y=-1;
			return FREEING;
		}
		if(! terCheckPos(ter_data, prjpos->x, prjpos->y-1) && 
		   prjpos->vy==0 && prjpos->y>0)
		{
			prjpos->y--;
			continue;	
		}
		if(prjpos->vx>0) 
		{
			if(! terCheckPos(ter_data, prjpos->x+1, prjpos->y)) 
			{
				prjpos->x++;
				prjpos->vy=0;
				continue;
			}
			else 
			{
				if(! terCheckSpan(&ter_data[(int)rint(prjpos->x)+1], prjpos->y, 2)) 
				{
					prjpos->y++;
					prjpos->vy=1;
					continue;
				}
				else 
				{
					aihExplosionHook(prjpos);
					return initexplosion(prjpos, explosioninfo);
				}
			}
		}
		else 
		{
			if(! terCheckPos(ter_data, prjpos->x-1, prjpos->y)) 
			{
				prjpos->x--;
				prjpos->vy=0;
				continue;
			}
			else 
			{
				if(! terCheckSpan(&ter_data[(int)rint(prjpos->x)-1], prjpos->y, 2)) 
				{
					prjpos->y++;
					prjpos->vy=1;
					continue;
				}
				else {
					aihExplosionHook(prjpos);
					return initexplosion(prjpos, explosioninfo);
				}
			}
		}
	}
    return FLYING;
}

Shellstat_bal wepRollerExplosionInit(struct Projectilepos_bal *prjpos, void** explosioninfo)
{
	struct Projectilelist_bal *prj;
	Weapon_wep *wp;
	
	wp=wepLookupWeapon("Roller Ball");
	prj=balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx, prjpos->vy, wp);
	prj->stat=INITSHOT(prj);

    return FREEING;
}
