///////////////////////////////////////////////////////////////////////////////
// $Id: AboutOkOrCloseCommand.hxx,v 1.1 1995/01/08 06:40:12 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// AboutOkOrCloseCommand.hxx - Command executed when the user presses ok
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 14,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: AboutOkOrCloseCommand.hxx,v $
// Revision 1.1  1995/01/08  06:40:12  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef ABOUTOKORCLOSECOMMAND_HXX
#define ABOUTOKORCLOSECOMMAND_HXX

#include "Command.hxx"
#include "CommandFlags.hxx"
#include "About.hxx"

class AboutOkOrCloseCommand : public Command {
  private:
    About* myAbout;

  public:
    // Protected constructor to prevent instantiation
    AboutOkOrCloseCommand(About* about)
        : myAbout(about)
    {};

    // Destructor
    virtual ~AboutOkOrCloseCommand() {};

    // Delete my about dialog
    virtual void execute(void* argument)
    {
      delete myAbout;
      aboutCurrentlyDisplayedFlag = 0;
    }
};
#endif

