///////////////////////////////////////////////////////////////////////////////
// $Id: HelpCommand.hxx,v 1.1 1995/01/08 06:41:41 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// HelpCommand.hxx - Command to help the user with oonsoo
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: HelpCommand.hxx,v $
// Revision 1.1  1995/01/08  06:41:41  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef HELPCOMMAND_HXX
#define HELPCOMMAND_HXX

#include "Help.hxx"
#include "Command.hxx"
#include "CommandFlags.hxx"


class HelpCommand : public Command {
  private:
    SpriteCollection* mySprites;

  public:
    // Protected constructor to prevent instantiation
    HelpCommand(SpriteCollection* sprites)
        :mySprites(sprites)
    {};

    // Destructor
    virtual ~HelpCommand() {};

    // Create a help dialog
    virtual void execute(void* argument)
    {
      if(!helpCurrentlyDisplayedFlag)
      {
        new Help(mySprites);
        helpCurrentlyDisplayedFlag = 1;
      }
    }
};
#endif

