///////////////////////////////////////////////////////////////////////////////
// $Id: Sprite.hxx,v 1.1 1995/01/08 06:51:42 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Sprite.hxx - Sprite class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// November 3,1994
//
///////////////////////////////////////////////////////////////////////////////
//
///////////////////////////////////////////////////////////////////////////////

#ifndef SPRITE_HXX
#define SPRITE_HXX

#include <X11/Xlib.h>

class Sprite {
  int myWidth, myHeight;
  char* myName;
  unsigned char* myData;
  XImage* myImage;
 
  public:
    // Constructor
    Sprite::Sprite(unsigned char* spriteData);

    // Destructor 
    virtual ~Sprite();

    // Answer my name
    const char* name() const { return(myName); }

    // Answer my width
    int width() const { return(myWidth); }

    // Answer my height
    int height() const { return(myHeight); }

    // Answer my XImage
    XImage* image() const { return(myImage); }
};
#endif

