## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import sys

# PySol imports
if sys.modules.has_key("pysoltk"):                                  #bundle#
    from gamedb import registerGame, GameInfo, GI                   #bundle#
    from util import *                                              #bundle#
    from stack import *                                             #bundle#
    from game import Game                                           #bundle#
    from layout import Layout                                       #bundle#
    from hint import AbstractHint, DefaultHint, CautiousDefaultHint #bundle#


# /***********************************************************************
# // Eiffel Tower
# ************************************************************************/

class EiffelTower_RowStack(OpenStack):
    def __init__(self, x, y, game):
        OpenStack.__init__(self, x, y, game, max_accept=1)
        self.CARD_YOFFSET = 1

    def canMovePile(self, cards):
        return 0

    def acceptsPile(self, from_stack, cards):
        if not self.cards or len(cards) != 1:
            return 0
        if not cards[0].face_up or not self.cards[-1].face_up:
            return 0
        return cards[0].rank + self.cards[-1].rank == 12


class EiffelTower(Game):

    #
    # game layout
    #

    def createGame(self):
        # create layout
        l, s = Layout(self), self.s

        # set window
        self.setSize(l.XM + 8.5*l.XS, l.YM + 6*l.YS)

        # create stacks
        y = l.YM
        for d in ((1, 2.5), (2, 2), (3, 1.5), (4, 1), (5, 0.5), (5, 0.5)):
            x = l.XM + d[1] * l.XS
            for i in range(d[0]):
                s.rows.append(EiffelTower_RowStack(x, y, self))
                x = x + l.XS
            y = y + l.YS
        x = l.XM + 6 * l.XS
        y = l.YM + 5 * l.YS / 2
        s.waste = WasteStack(x, y, self)
        l.createText(s.waste, "ss")
        x = x + l.XS
        s.talon = WasteTalonStack(x, y, self, max_rounds=1)
        l.createText(s.talon, "ss")

        # define stack-groups
        l.defaultStackGroups()

    #
    # game overrides
    #

    def startGame(self):
        self.s.talon.dealRow()
        self.s.talon.dealCards()          # deal first card to WasteStack

    def isGameWon(self):
        return len(self.s.talon.cards) == 0 and len(self.s.waste.cards) == 0

    def getAutoStacks(self, event=None):
        return ((), (), ())

    def shallHighlightMatch(self, stack1, card1, stack2, card2):
        return card1.rank + card2.rank == 12


# register the game
registerGame(GameInfo(16, EiffelTower, "Eiffel Tower",
                      GI.GT_PAIRING_TYPE, 2, 0))

