## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import sys, os, string, types
if os.name == "mac":                                                #bundle#
    import macfs, MACFS                                             #bundle#
try:                                                                #bundle#
    from cPickle import Pickler, Unpickler, UnpicklingError         #bundle#
except ImportError:                                                 #bundle#
    from pickle import Pickler, Unpickler, UnpicklingError          #bundle#


# /***********************************************************************
# // exceptions
# ************************************************************************/

# work around a Mac problem
##EnvError = EnvironmentError
EnvError = (IOError, OSError, os.error,)


class SubclassResponsibility(Exception):
    pass


# /***********************************************************************
# // misc. util
# ************************************************************************/

def static(f, *args, **kw):
    if args:
        a = tuple([f.im_class()] + list(args))
    else:
        a = (f.im_class(),)
    return apply(f, a, kw)


def bool(expr):
    if expr:
        return 1
    return 0


def ifelse(expr, val1, val2):
    if expr:
        return val1
    return val2


def merge_dict(dict1, dict2, merge_none=1):
    for k, v in dict2.items():
        if dict1.has_key(k):
            if type(dict1[k]) == type(v):
                dict1[k] = v
            elif dict1[k] is None and merge_none:
                dict1[k] = v


def gethomedir():
    default_home = os.curdir
    if os.name == "nt": default_home = "c:\\"
    home = string.strip(os.environ.get("HOME", ""))
    if not home or not os.path.isdir(home):
        if os.name == "nt":
            home = os.environ.get("HOMEDRIVE", "") + os.environ.get("HOMEPATH", "")
    if not home or not os.path.isdir(home):
        home = default_home
    return home


def getprefdir(package, home=None):
    if os.name == "mac":
        vrefnum, dirid = macfs.FindFolder(MACFS.kOnSystemDisk, MACFS.kPreferencesFolderType, 0)
        fss = macfs.FSSpec((vrefnum, dirid, ":" + package))
        return fss.as_pathname()
    if home is None:
        home = gethomedir()
    return os.path.join(home, "." + string.lower(package))


# /***********************************************************************
# // memory util
# ************************************************************************/

def destruct(obj):
    # assist in breaking circular references
    if obj is not None:
        assert type(obj) == types.InstanceType
        for k in obj.__dict__.keys():
            obj.__dict__[k] = None
            ##del obj.__dict__[k]


# /***********************************************************************
# //
# ************************************************************************/

class Struct:
    def __init__(self, **kw):
        self.__dict__.update(kw)

    def __str__(self):
        return str(self.__dict__)

#%ifndef BUNDLE
    def __setattr__(self, name, value):
        if not self.__dict__.has_key(name):
            raise AttributeError, name
        self.__dict__[name] = value
#%endif

    def addattr(self, **kw):
        for name in kw.keys():
            if hasattr(self, name):
                raise AttributeError, name
        self.__dict__.update(kw)

    def update(self, dict):
        for name in dict.keys():
            if not self.__dict__.has_key(name):
                raise AttributeError, name
        self.__dict__.update(dict)

    def clear(self):
        for name in self.__dict__.keys():
            t = type(name)
            if t == types.ListType:
                self.__dict__[name] = []
            elif t == types.TupleType:
                self.__dict__[name] = ()
            elif t == types.DictType:
                self.__dict__[name] = {}
            else:
                self.__dict__[name] = None

    def copy(self):
        c = Struct()
        c.__class__ = self.__class__
        c.__dict__.update(self.__dict__)
        return c


# /***********************************************************************
# // keyword argument util
# ************************************************************************/

# update keyword arguments with default arguments
def kwdefault(kw, **defaults):
    for k, v in defaults.items():
        if not kw.has_key(k):
            kw[k] = v


class KwStruct:
    def __init__(self, kw={}, **defaults):
        if isinstance(kw, KwStruct):
            kw = kw.__dict__
        if isinstance(defaults, KwStruct):
            defaults = defaults.__dict__
        for k, v in defaults.items():
            if not kw.has_key(k):
                kw[k] = v
        self.__dict__.update(kw)

    def __setattr__(self, key, value):
        if not self.__dict__.has_key(key):
            raise AttributeError, name
        self.__dict__[key] = value

    def __getitem__(self, key):
        return getattr(self, key)

    def get(self, key, default=None):
        return self.__dict__.get(key, default)


# /***********************************************************************
# // pickling support
# ************************************************************************/

def pickle(obj, filename, binmode=0):
    f = None
    try:
        f = open(filename, "wb")
        p = Pickler(f, binmode)
        p.dump(obj)
        f.close(); f = None
        ##print "Pickled", filename
    finally:
        if f: f.close()


def unpickle(filename):
    f = obj = None
    try:
        f = open(filename, "rb")
        p = Unpickler(f)
        x = p.load()
        f.close(); f = None
        obj = x
        ##print "Unpickled", filename
    finally:
        if f: f.close()
    return obj


# /***********************************************************************
# // memory debugging
# ************************************************************************/

#%ifndef BUNDLE

def dumpmem(dump_all_objects=1):
    var = {}
    if dump_all_objects:
        for m in sys.modules.keys():
            mod = sys.modules[m]
            if mod:
                for k in mod.__dict__.keys():
                    v = mod.__dict__[k]
                    if type(v) in (types.ClassType, types.InstanceType):
                        var[k] = v
    else:
        for k, v in vars().items() + globals().items():
            var[k] = v
    info = []
    for k in var.keys():
        n = sys.getrefcount(var[k])
        v = var[k]
        if type(v) == types.ClassType:
            ## FIXME: we must subtract the number of methods
            ## FIXME: we must also subtract the number of subclasses
            pass
        if n > 3:
            # we seem to create 3 (???) extra references while in this function
            info.append(n - 3, k, v)
        var[k] = None
    var = None
    info.sort()
    info.reverse()
    sum = 0
    for count, varname, value in info:
        sum = sum + count
        if type(value) in (
            types.InstanceType, types.ModuleType, types.ClassType,
            types.NoneType, types.FunctionType, types.StringType
            ):
            valuestr = repr(value)[:40]
        else:
            valuestr = "n/a"
        print "%7d %-25s %s" % (count, varname, valuestr)
    print "%7d ---TOTAL---" % (sum)

#%endif


# /***********************************************************************
# // debugging
# ************************************************************************/

def callername():
    try:
        raise Exception
    except:
        return sys.exc_traceback.tb_frame.f_back.f_back.f_code.co_name

def callerglobals():
    try:
        raise Exception
    except:
        return sys.exc_traceback.tb_frame.f_back.f_back.f_globals

def uplevel(name):
    print __name__, callerglobals()[name], callerglobals()["__name__"]

